/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.properties.dialog;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MDummy;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RepositoryComposite
extends Composite {
    private boolean showCompatible;
    private INode root;
    protected AMResource resource;
    private TreeViewer treeViewer;

    public RepositoryComposite(Composite parent, int style, INode root, boolean showCompatible) {
        super(parent, style);
        this.showCompatible = showCompatible;
        this.root = root;
        this.createComposite();
    }

    protected void createComposite() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer((Composite)this, 4);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (RepositoryComposite.this.showCompatible) {
                    return super.getChildren(parentElement);
                }
                if (parentElement instanceof INode) {
                    INode node = (INode)parentElement;
                    ArrayList<INode> res = new ArrayList<INode>();
                    for (INode n : node.getChildren()) {
                        if (!(n instanceof MFolder) && !(n instanceof MDummy) && (!(n instanceof AMResource) || !RepositoryComposite.this.isResourceCompatible((AMResource)n))) continue;
                        res.add(n);
                    }
                    return res.toArray();
                }
                return EMPTY_ARRAY;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(event -> {
            TreeSelection ts = (TreeSelection)event.getSelection();
            Object obj = ts.getFirstElement();
            if (obj instanceof AMResource) {
                AMResource mres = (AMResource)((Object)((Object)obj));
                boolean resCompatible = this.isResourceCompatible(mres);
                this.setOkButtonEnabled(resCompatible);
                if (resCompatible) {
                    this.setResource((AMResource)((Object)((Object)obj)));
                }
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){
            private RefreshResourcesAction refreshAction;

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection ts = (TreeSelection)RepositoryComposite.this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof AMResource) {
                    AMResource mres = (AMResource)((Object)el);
                    boolean resCompatible = RepositoryComposite.this.isResourceCompatible(mres);
                    if (resCompatible) {
                        RepositoryComposite.this.okPressed();
                        return;
                    }
                    if (mres instanceof MFolder) {
                        if (RepositoryComposite.this.treeViewer.getExpandedState(el)) {
                            RepositoryComposite.this.treeViewer.collapseToLevel(el, 1);
                        } else {
                            if (this.refreshAction == null) {
                                this.refreshAction = new RefreshResourcesAction(RepositoryComposite.this.treeViewer);
                            }
                            if (this.refreshAction.isEnabled()) {
                                this.refreshAction.run();
                            }
                            RepositoryComposite.this.treeViewer.expandToLevel(el, 1);
                        }
                    }
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){
            private ServerProvider serverProvider;

            public void treeExpanded(TreeExpansionEvent event) {
                if (this.serverProvider == null) {
                    this.serverProvider = new ServerProvider();
                }
                this.serverProvider.handleTreeEvent(event);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        UIUtils.getDisplay().asyncExec(this::createReadRepositoryJob);
    }

    protected void createReadRepositoryJob() {
        Job job = new Job("Looking into repository"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Looking into repository", -1);
                return RepositoryComposite.this.doReadRepository(monitor);
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    protected IStatus doReadRepository(IProgressMonitor monitor) {
        try {
            try {
                MServerProfile msp = null;
                if (this.root instanceof MServerProfile) {
                    msp = (MServerProfile)this.root;
                } else if (this.root instanceof AMResource) {
                    msp = (MServerProfile)((AMResource)this.root).getRoot();
                }
                if (ModelUtils.isEmpty((ANode)msp)) {
                    WSClientHelper.connectGetData(msp, monitor);
                }
                UIUtils.getDisplay().asyncExec(() -> this.treeViewer.setInput((Object)this.root));
            }
            catch (Exception e) {
                UIUtils.showError((Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                monitor.done();
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean isResourceCompatible(AMResource r) {
        return true;
    }

    public void setResource(AMResource res) {
        this.resource = res;
    }

    protected void okPressed() {
    }

    protected void setOkButtonEnabled(boolean resCompatible) {
    }
}

