/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol;

import com.jaspersoft.studio.server.messages.Messages;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class CRLVerifier {
    public static void verifyCertificateCRLs(X509Certificate cert) throws CertificateException {
        try {
            List<String> crlDistPoints = CRLVerifier.getCrlDistributionPoints(cert);
            for (String crlDP : crlDistPoints) {
                X509CRL crl = CRLVerifier.downloadCRL(crlDP);
                if (!crl.isRevoked(cert)) continue;
                throw new CertificateException(String.valueOf(Messages.CRLVerifier_0) + crlDP);
            }
        }
        catch (CertificateException ex) {
            throw ex;
        }
        catch (Exception exception) {
            throw new CertificateException(String.valueOf(Messages.CRLVerifier_1) + cert.getSubjectX500Principal());
        }
    }

    private static X509CRL downloadCRL(String crlURL) throws IOException, CRLException, CertificateException, NamingException {
        if (crlURL.startsWith(Messages.CRLVerifier_2) || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            return CRLVerifier.downloadCRLFromWeb(crlURL);
        }
        if (crlURL.startsWith("ldap://")) {
            return CRLVerifier.downloadCRLFromLDAP(crlURL);
        }
        throw new CertificateException(String.valueOf(Messages.CRLVerifier_6) + crlURL);
    }

    private static X509CRL downloadCRLFromLDAP(String ldapURL) throws NamingException, CRLException, CertificateException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", Messages.CRLVerifier_7);
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext((Hashtable)((Object)env));
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get(Messages.CRLVerifier_9);
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new CertificateException(String.valueOf(Messages.CRLVerifier_10) + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509CRL)cf.generateCRL(inStream);
    }

    private static X509CRL downloadCRLFromWeb(String crlURL) throws IOException, CertificateException, CRLException {
        InputStream crlStream = new URL(crlURL).openStream();
        try {
            X509CRL x509CRL = (X509CRL)CertificateFactory.getInstance("X.509").generateCRL(crlStream);
            return x509CRL;
        }
        finally {
            FileUtils.closeStream((Closeable)crlStream);
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate cert) throws IOException {
        byte[] crldpExt = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crldpExt == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        ASN1InputStream oAsnInStream = null;
        ASN1InputStream oAsnInStream2 = null;
        try {
            oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
            ASN1Primitive derObjCrlDP = oAsnInStream.readObject();
            DEROctetString dosCrlDP = (DEROctetString)derObjCrlDP;
            byte[] crldpExtOctets = dosCrlDP.getOctets();
            oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
            CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)oAsnInStream2.readObject());
            DistributionPoint[] distributionPointArray = distPoint.getDistributionPoints();
            int n = distributionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                DistributionPoint dp = distributionPointArray[n2];
                DistributionPointName dpn = dp.getDistributionPoint();
                if (dpn != null && dpn.getType() == 0) {
                    GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
                    int j = 0;
                    while (j < genNames.length) {
                        if (genNames[j].getTagNo() == 6) {
                            crlUrls.add(DERIA5String.getInstance((Object)genNames[j].getName()).getString());
                        }
                        ++j;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(oAsnInStream);
            FileUtils.closeStream(oAsnInStream2);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)oAsnInStream);
        FileUtils.closeStream((Closeable)oAsnInStream2);
        return crlUrls;
    }
}

