/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.fluent.Request;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConnectionManager {
    private static Map<Request, IProgressMonitor> requests = new HashMap<Request, IProgressMonitor>();
    private static Thread mct = new Thread(new MonitorCancelThread());

    static {
        mct.start();
    }

    public static synchronized void register(IProgressMonitor monitor, Request req) {
        requests.put(req, monitor);
    }

    public static synchronized void unregister(Request req) {
        requests.remove(req);
    }

    private static synchronized void clean() {
        for (Request r : requests.keySet()) {
            IProgressMonitor m = requests.get(r);
            if (!m.isCanceled()) continue;
            r.abort();
            requests.remove(r);
        }
    }

    private static class MonitorCancelThread
    implements Runnable {
        private MonitorCancelThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    ConnectionManager.clean();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

