/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol;

import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.apache.http.conn.ssl.TrustStrategy;

public class JSSTrustStrategy
implements TrustStrategy {
    private KeyStore trustStore;

    public JSSTrustStrategy(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            CertChainValidator.validateKeyChain(chain, this.trustStore);
            return true;
        }
        catch (KeyStoreException e) {
            throw new CertificateException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CertificateException(e);
        }
        catch (IOException e) {
            UIUtils.showError((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException(e);
        }
        return false;
    }
}

