/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol;

import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import java.util.HashMap;
import java.util.Map;

public class Version {
    private static final Map<String, String> jrs2jr = new HashMap<String, String>();

    static {
        jrs2jr.put("7.1.0", "6.4.3");
        jrs2jr.put("7.1.1", "6.4.3");
        jrs2jr.put("7.1.2", "6.4.3");
        jrs2jr.put("7.2.0", "6.5.1");
        jrs2jr.put("7.5.0", "6.11.0");
    }

    public static boolean isPro(ServerInfo si) {
        return si.getEdition() == ServerInfo.ServerEdition.PRO;
    }

    public static String setJRVersion(ServerInfo si) {
        String v = jrs2jr.get(si.getVersion());
        if (v != null) {
            return v;
        }
        for (String av : JRXmlWriterHelper.getVersionsSet()) {
            if (!av.equals(si.getVersion())) continue;
            return av;
        }
        return "last";
    }

    public static boolean isEstimated(ServerInfo si) {
        for (String av : JRXmlWriterHelper.getVersionsSet()) {
            if (!av.equals(si.getVersion())) continue;
            return false;
        }
        return true;
    }

    public static boolean isDateRangeSupported(ServerInfo si) {
        return si.getVersion().startsWith("5.");
    }

    public static boolean isXMLACoonnectionSupported(IConnection c) {
        if (c.isSupported(Feature.SEARCHREPOSITORY)) {
            ServerInfo si = c.getServerInfo();
            return si.getVersion().startsWith("5.5") || si.getVersion().startsWith("5.6");
        }
        return true;
    }

    public static boolean isGreaterThan(ServerInfo si, String version) {
        return si.getVersion().compareTo(version) >= 0;
    }
}

