/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.preferences.CASListFieldEditor;
import com.jaspersoft.studio.server.preferences.SSOServer;
import com.jaspersoft.studio.server.protocol.ConnectionManager;
import com.jaspersoft.studio.server.utils.HttpUtils;
import com.jaspersoft.studio.server.utils.Pass;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sf.jasperreports.eclipse.util.CastorHelper;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.core.runtime.IProgressMonitor;
import org.exolab.castor.mapping.Mapping;

public class CASUtil {
    private static final Pattern formPattern = Pattern.compile("<form(.*?)>", 34);
    private static final Pattern inputPattern = Pattern.compile("<input(.*?)>", 34);
    private static final Pattern ahrefPattern = Pattern.compile("<a(.*?)>", 34);
    private static final Pattern attributePattern = Pattern.compile("(\\w+)=\"(.*?)\"");

    public static String getToken(ServerProfile sp, IProgressMonitor monitor) throws Exception {
        String v = null;
        v = JasperReportsConfiguration.getDefaultInstance().getPrefStore().getString("com.jaspersoft.studio.server.sso");
        String[] stringArray = v.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    SSOServer srv = null;
                    try {
                        srv = (SSOServer)CastorHelper.read((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)line)), (Mapping)CASListFieldEditor.getMapping());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block5;
                    }
                    if (srv.getUuid().equals(sp.getSsoUuid())) {
                        return CASUtil.doGetTocken(sp, srv, monitor);
                    }
                }
            }
            ++n2;
        }
        throw new Exception("Could not find SSO Server in the list.");
    }

    public static SSOServer getSSO(ServerProfile sp, IProgressMonitor monitor) throws Exception {
        String v = null;
        v = JasperReportsConfiguration.getDefaultInstance().getPrefStore().getString("com.jaspersoft.studio.server.sso");
        String[] stringArray = v.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    SSOServer srv = null;
                    try {
                        srv = (SSOServer)CastorHelper.read((InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)line)), (Mapping)CASListFieldEditor.getMapping());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block5;
                    }
                    if (srv.getUuid().equals(sp.getSsoUuid())) {
                        return srv;
                    }
                }
            }
            ++n2;
        }
        throw new Exception("Could not find SSO Server in the list.");
    }

    public static String doGetTocken(ServerProfile sp, SSOServer srv, IProgressMonitor monitor) throws Exception {
        String url;
        String tgtID;
        String action;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setDefaultCookieStore((CookieStore)new BasicCookieStore()).setUserAgent("Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:31.0) Gecko/20100101 Firefox/31.0").build();
        Executor exec = Executor.newInstance((HttpClient)httpclient);
        URIBuilder ub = new URIBuilder(String.valueOf(sp.getUrl()) + "index.html");
        String fullURL = ub.build().toASCIIString();
        Request req = HttpUtils.get(fullURL, sp);
        HttpHost proxy = net.sf.jasperreports.eclipse.util.HttpUtils.getUnauthProxy((Executor)exec, (URI)new URI(fullURL));
        if (proxy != null) {
            req.viaProxy(proxy);
        }
        if ((action = CASUtil.getFormAction(tgtID = CASUtil.readData(exec, req, monitor))) != null) {
            int indx = (action = action.replaceFirst("/", "")).indexOf(";jsession");
            if (indx >= 0) {
                action = action.substring(0, indx);
            }
        } else {
            action = "cas/login";
        }
        if (!(url = srv.getUrl()).endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        ub = new URIBuilder(String.valueOf(url) + action);
        fullURL = ub.build().toASCIIString();
        req = HttpUtils.get(fullURL, sp);
        proxy = net.sf.jasperreports.eclipse.util.HttpUtils.getUnauthProxy((Executor)exec, (URI)new URI(fullURL));
        if (proxy != null) {
            req.viaProxy(proxy);
        }
        tgtID = CASUtil.readData(exec, req, monitor);
        action = CASUtil.getFormAction(tgtID);
        action = action.replaceFirst("/", "");
        ub = new URIBuilder(String.valueOf(url) + action);
        Map<String, String> map = CASUtil.getInputs(tgtID);
        Form form = Form.form();
        for (String key : map.keySet()) {
            if (key.equals("btn-reset")) continue;
            if (key.equals("username")) {
                form.add(key, srv.getUser());
                continue;
            }
            if (key.equals("password")) {
                form.add(key, Pass.getPass(srv.getPassword()));
                continue;
            }
            form.add(key, map.get(key));
        }
        req = HttpUtils.post(ub.build().toASCIIString(), form, sp);
        if (proxy != null) {
            req.viaProxy(proxy);
        }
        CASUtil.readData(exec, req, monitor);
        ub = new URIBuilder(String.valueOf(url) + action);
        url = sp.getUrl();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        ub.addParameter("service", String.valueOf(url) + "j_spring_security_check");
        req = HttpUtils.get(ub.build().toASCIIString(), sp);
        if (proxy != null) {
            req.viaProxy(proxy);
        }
        req.addHeader("Referrer", sp.getUrl());
        String html = CASUtil.readData(exec, req, monitor);
        Matcher matcher = ahrefPattern.matcher(html);
        while (matcher.find()) {
            Map<String, String> attributes = CASUtil.parseAttributes(matcher.group(1));
            String v = attributes.get("href");
            int ind = v.indexOf("ticket=");
            if (ind <= 0) continue;
            return v.substring(ind + "ticket=".length());
        }
        return null;
    }

    private static Map<String, String> getInputs(String html) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher matcher = inputPattern.matcher(html);
        while (matcher.find()) {
            Map<String, String> attributes = CASUtil.parseAttributes(matcher.group(1));
            map.put(attributes.get("name"), attributes.get("value"));
        }
        return map;
    }

    private static String getFormAction(String html) {
        Matcher matcher = formPattern.matcher(html);
        if (matcher.find()) {
            Map<String, String> attributes = CASUtil.parseAttributes(matcher.group(1));
            return attributes.get("action");
        }
        return null;
    }

    private static Map<String, String> parseAttributes(String attributesStr) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = attributePattern.matcher(attributesStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = "";
            String g = matcher.group(2).trim();
            if (g != null) {
                value = g;
            }
            attributes.put(key, value.trim());
        }
        return attributes;
    }

    private static String readData(Executor exec, Request req, IProgressMonitor monitor) throws IOException {
        String obj = null;
        ConnectionManager.register(monitor, req);
        try {
            try {
                obj = (String)exec.execute(req).handleResponse((ResponseHandler)new ResponseHandler<String>(){

                    public String handleResponse(HttpResponse response) throws IOException {
                        HttpEntity entity = response.getEntity();
                        InputStream in = null;
                        String res = null;
                        try {
                            StatusLine statusLine = response.getStatusLine();
                            switch (statusLine.getStatusCode()) {
                                case 200: {
                                    in = this.getContent(entity);
                                    res = IOUtils.toString((InputStream)in);
                                    break;
                                }
                                default: {
                                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            FileUtils.closeStream(in);
                            throw throwable;
                        }
                        FileUtils.closeStream((Closeable)in);
                        return res;
                    }

                    protected InputStream getContent(HttpEntity entity) throws ClientProtocolException, IOException {
                        if (entity == null) {
                            throw new ClientProtocolException("Response contains no content");
                        }
                        return entity.getContent();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            ConnectionManager.unregister(req);
        }
        return obj;
    }
}

