/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.restv2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.jaxb.XmlJaxbAnnotationIntrospector;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.text.DateFormat;

public class JacksonHelper {
    public static ObjectMapper getJSONMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector primary = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        mapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary));
        JacksonHelper.setupMapper(mapper);
        return mapper;
    }

    public static XmlMapper getXMLMapper() {
        XmlMapper mapper = new XmlMapper();
        XmlJaxbAnnotationIntrospector primary = new XmlJaxbAnnotationIntrospector(mapper.getTypeFactory());
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        mapper.setAnnotationIntrospector(AnnotationIntrospector.pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary));
        JacksonHelper.setupMapper((ObjectMapper)mapper);
        return mapper;
    }

    private static void setupMapper(ObjectMapper mapper) {
        mapper.getSerializationConfig().with((DateFormat)new StdDateFormat());
        mapper.getDeserializationConfig().with((DateFormat)new StdDateFormat());
        mapper.addHandler(new DeserializationProblemHandler(){

            public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser jp, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException, JsonProcessingException {
                return true;
            }
        });
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

