/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish;

import com.jaspersoft.studio.editor.AMultiEditor;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.publish.action.JrxmlPublishAction;
import com.jaspersoft.studio.server.publish.wizard.PublishFile2ServerWizard;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.compatibility.HandlerUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationWizardDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class PublishHandler
extends AbstractHandler {
    private static IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput ei;
        ArrayList<IResource> files = new ArrayList<IResource>();
        JasperReportsConfiguration jContext = null;
        boolean disposeJrContext = false;
        ISelection sel = org.eclipse.ui.handlers.HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof StructuredSelection) {
            for (Object obj : (StructuredSelection)sel) {
                if (obj instanceof IFile) {
                    files.add((IResource)((IFile)obj));
                    continue;
                }
                if (obj instanceof IFolder) {
                    files.add((IResource)obj);
                    continue;
                }
                if (obj instanceof JarPackageFragmentRoot) {
                    try {
                        ZipFile zf = ((JarPackageFragmentRoot)obj).getJar();
                        if (zf == null) continue;
                        files.add((IResource)this.getFileFromURI(new URI(zf.getName())));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (obj instanceof CompilationUnit) {
                    files.add((IResource)this.getFileFromURI(((CompilationUnit)obj).getPath().toFile().toURI()));
                    continue;
                }
                if (!(obj instanceof IProject) && !(obj instanceof IPackageFragment) && !(obj instanceof PackageFragmentRoot) && !(obj instanceof ClassPathContainer)) continue;
                UIUtils.showInformation((String)"Currently this type of operation is not supported, only publishing files is supported");
                return null;
            }
        }
        if (files.isEmpty() && (ei = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)ei).getFile();
            IEditorPart ep = org.eclipse.ui.handlers.HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (ep instanceof AbstractJRXMLEditor) {
                try {
                    jContext = ((AbstractJRXMLEditor)ep).getJrContext(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (ep instanceof AMultiEditor) {
                try {
                    jContext = ((AMultiEditor)ep).getJrContext(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Object obj = ep.getAdapter(IFile.class);
                if (obj instanceof List) {
                    files.addAll((List)obj);
                }
            }
            if (!files.contains(f)) {
                files.add((IResource)f);
            }
        }
        if (files.isEmpty()) {
            UIUtils.showInformation((String)Messages.PublishHandler_0);
        } else {
            IFile f;
            String ext;
            if (files.get(0) instanceof IFile && ((ext = (f = (IFile)files.get(0)).getFileExtension()).equals("jrxml") || ext.equals("jasper") || Misc.isNullOrEmpty((String)ext))) {
                if (jContext == null) {
                    jContext = JasperReportsConfiguration.getDefaultJRConfig((IFile)f);
                    disposeJrContext = true;
                    try {
                        jContext.setJasperDesign(JRXMLUtils.getJasperDesign((JasperReportsConfiguration)jContext, (InputStream)f.getContents(), null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        jContext.dispose();
                        jContext = null;
                    }
                }
                if (jContext != null) {
                    JrxmlPublishAction publishAction = new JrxmlPublishAction(1, null);
                    publishAction.setJrConfig(jContext);
                    publishAction.run();
                    if (disposeJrContext) {
                        jContext.dispose();
                    }
                    return null;
                }
            }
            PublishFile2ServerWizard wizard = new PublishFile2ServerWizard(files, 1);
            new PersistentLocationWizardDialog(UIUtils.getShell(), (IWizard)wizard).open();
        }
        return null;
    }

    private IFile getFileFromURI(URI uri) {
        IFile[] res = root.findFilesForLocationURI(uri);
        if (res != null && res.length > 0) {
            return res[0];
        }
        return null;
    }
}

