/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.imp;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.publish.OverwriteEnum;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AImpObject {
    protected JasperReportsConfiguration jrConfig;

    public AImpObject(JasperReportsConfiguration jrConfig) {
        this.jrConfig = jrConfig;
    }

    protected AFileResource findFile(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jd, Set<String> fileset, JRDesignExpression exp, IFile file) {
        String str = this.getPath(fileset, exp);
        if (Misc.isNullOrEmpty((String)str)) {
            return null;
        }
        if (fileset.contains(str)) {
            File f = this.findFile(file, str);
            if (f != null && f.exists()) {
                AImpObject.setupSameExpression(mrunit, exp, this.doPath(this.getFileName(f)));
            } else {
                AImpObject.setupSameExpression(mrunit, exp, this.doPath(str));
            }
            return null;
        }
        File f = this.findFile(file, str);
        if (f != null && f.exists()) {
            PublishOptions popt = AImpObject.createOptions(this.jrConfig, str);
            popt.setjExpression(exp);
            if (!f.getName().contains(":")) {
                popt.setExpression("\"repo:" + IDStringValidator.safeChar((String)this.getFileName(f)) + "\"");
            }
            fileset.add(str);
            return this.addResource(monitor, mrunit, fileset, f, popt);
        }
        return null;
    }

    protected String getFileName(File f) {
        String fname = f.getName();
        if (fname.contains("___$$tmpcopy")) {
            int ind = fname.indexOf("___$$tmpcopy");
            fname = fname.substring(0, ind);
        }
        return fname;
    }

    protected String doPath(String path) {
        return path;
    }

    public static void setupSameExpression(MReportUnit mrunit, JRDesignExpression exp, String str) {
        str = "\"repo:" + IDStringValidator.safeChar((String)str) + "\"";
        PublishOptions popt = mrunit.getPublishOptions();
        if (popt != null && popt.getExpression() != null && popt.getExpression().equals(str)) {
            popt.setjExpression(exp);
            return;
        }
        for (INode n : mrunit.getChildren()) {
            if (!(n instanceof AFileResource) || (popt = ((AFileResource)n).getPublishOptions()) == null || popt.getExpression() == null || !popt.getExpression().equals(str)) continue;
            popt.setjExpression(exp);
            break;
        }
    }

    public static PublishOptions createOptions(JasperReportsConfiguration jrConfig, String path) {
        PublishOptions popt = new PublishOptions();
        String b = jrConfig.getProperty("com.jaspersoft.studio.server.PUBLISH_REPORT_OVERRIDEBYDEFAULT", "true");
        if (b.equals("ignore")) {
            popt.setOverwrite(OverwriteEnum.IGNORE);
        } else if (b.equals("overwrite")) {
            popt.setOverwrite(OverwriteEnum.OVERWRITE);
        } else if (!b.equals("true") || path != null && AImpObject.isRemoteResource(path)) {
            popt.setOverwrite(OverwriteEnum.IGNORE);
        } else {
            popt.setOverwrite(OverwriteEnum.OVERWRITE);
        }
        return popt;
    }

    public static boolean isRemoteResource(String path) {
        return path != null && path.startsWith("\\w+?://") && !path.startsWith("file://");
    }

    protected String getPath(Set<String> fileset, JRDesignExpression exp) {
        String str = ExpressionUtil.cachedExpressionEvaluationString((JRExpression)exp, (JasperReportsConfiguration)this.jrConfig);
        return this.preparePath(fileset, str);
    }

    protected String preparePath(Set<String> fileset, String str) {
        if (str != null && str.startsWith("repo:")) {
            str = str.replaceFirst("repo:", "");
        }
        return str;
    }

    protected AFileResource addResource(IProgressMonitor monitor, MReportUnit mrunit, Set<String> fileset, File f, PublishOptions popt) {
        ResourceDescriptor runit = mrunit.getValue();
        String rname = this.getFileName(f);
        if (rname.startsWith("repo:")) {
            rname = rname.replaceFirst("repo:", "");
        }
        ResourceDescriptor rd = null;
        List<ResourceDescriptor> list = runit.getChildren();
        String idname = IDStringValidator.safeChar((String)rname);
        for (ResourceDescriptor r : list) {
            if (r.getName() == null || !r.getName().equals(idname)) continue;
            rd = r;
            break;
        }
        if (rd == null) {
            rd = this.createResource(mrunit);
            rd.setName(idname);
            rd.setLabel(rname);
            rd.setParentFolder(String.valueOf(runit.getUriString()) + "_files");
            rd.setUriString(String.valueOf(rd.getParentFolder()) + "/" + idname);
        }
        AMResource res = ResourceFactory.getResource((ANode)mrunit, rd, -1);
        String b = this.jrConfig.getProperty("com.jaspersoft.studio.server.PUBLISH_REPORT_OVERRIDEBYDEFAULT", "true");
        if (b.equals("true") && rd.getIsNew()) {
            popt.setOverwrite(OverwriteEnum.OVERWRITE);
        }
        res.setPublishOptions(popt);
        if (res instanceof AFileResource) {
            AFileResource mres = (AFileResource)res;
            mres.setFile(f);
            PublishUtil.getResources(mrunit, monitor, this.jrConfig).add(mres);
            return mres;
        }
        return null;
    }

    protected File findFile(IFile file, String str) {
        return FileUtils.findFile((IFile)file, (String)str, (JasperReportsContext)this.jrConfig);
    }

    public AFileResource publish(JasperDesign jd, JRDesignElement img, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file) throws Exception {
        return this.findFile(mrunit, monitor, jd, fileset, this.getExpression(img), file);
    }

    protected abstract ResourceDescriptor createResource(MReportUnit var1);

    protected abstract JRDesignExpression getExpression(JRDesignElement var1);
}

