/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.imp;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.MJar;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.publish.PublishOptions;
import com.jaspersoft.studio.server.publish.imp.AImpObject;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImpChartCustomizer
extends AImpObject {
    private HashSet<String> embeddedCustomizers;

    public ImpChartCustomizer(JasperReportsConfiguration jrConfig) {
        super(jrConfig);
        this.initializeEmbeddedCustmizers();
    }

    protected void initializeEmbeddedCustmizers() {
        this.embeddedCustomizers = new HashSet();
    }

    public File publish(JasperDesign jd, String className, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file, String version) throws Exception {
        AFileResource fres = this.findFile(mrunit, monitor, jd, fileset, file, className, version);
        return fres != null ? fres.getFile() : null;
    }

    @Override
    protected ResourceDescriptor createResource(MReportUnit mrunit) {
        return MJar.createDescriptor((ANode)mrunit);
    }

    @Override
    public AFileResource publish(JasperDesign jd, JRDesignElement img, MReportUnit mrunit, IProgressMonitor monitor, Set<String> fileset, IFile file) throws Exception {
        return null;
    }

    @Override
    protected JRDesignExpression getExpression(JRDesignElement img) {
        return null;
    }

    protected AFileResource findFile(MReportUnit mrunit, IProgressMonitor monitor, JasperDesign jd, Set<String> fileset, IFile reportFile, String className, String version) {
        try {
            Class<?> customizerClass;
            String str;
            File f;
            if (!this.embeddedCustomizers.contains(className) && (f = this.findFile(reportFile, str = this.findPathJar(customizerClass = this.jrConfig.getClassLoader().loadClass(className)))) != null && f.exists() && !fileset.contains(str)) {
                PublishOptions popt = ImpChartCustomizer.createOptions(this.jrConfig, str);
                fileset.add(str);
                return this.addResource(monitor, mrunit, fileset, f, popt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected String findPathJar(Class<?> customizerClass) throws IllegalStateException {
        String classFileName = String.valueOf('/') + customizerClass.getName().replace('.', '/') + ".class";
        String uri = customizerClass.getResource(classFileName).toString();
        if (!uri.startsWith("jar:file:")) {
            return null;
        }
        int idx = uri.indexOf(33);
        try {
            if (idx != -1) {
                return URLDecoder.decode(uri.substring("jar:file:".length(), idx), Charset.defaultCharset().name());
            }
            return URLDecoder.decode(uri.substring("jar:file:".length()), Charset.defaultCharset().name());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<String> getSubCustmizersClass(JRChart chart) {
        ArrayList<String> result = new ArrayList<String>();
        List properties = JRPropertiesUtil.getProperties((JRPropertiesMap)chart.getPropertiesMap(), (String)"net.sf.jasperreports.customizer.class.");
        for (JRPropertiesUtil.PropertySuffix prop : properties) {
            String customizerClass = prop.getValue();
            result.add(customizerClass);
        }
        return result;
    }
}

