/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard;

import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.publish.wizard.page.AFilesLocationPage;
import com.jaspersoft.studio.server.publish.wizard.page.FileSelectionPage;
import com.jaspersoft.studio.server.publish.wizard.page.RFileLocationPage;
import com.jaspersoft.studio.server.publish.wizard.page.RFilesLocationPage;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.FileEditorInput;

public class PublishFile2ServerWizard
extends Wizard
implements IExportWizard {
    private JasperReportsConfiguration jrConfig;
    private int startPage = 0;
    private List<IResource> files;
    private AFilesLocationPage page1;
    private ISelection selection;

    public PublishFile2ServerWizard() {
        this.setWindowTitle("Publish File To The JasperReports Server");
        this.setNeedsProgressMonitor(true);
    }

    public PublishFile2ServerWizard(List<IResource> files, int page) {
        this();
        this.files = files;
        this.startPage = page;
    }

    private void init() {
        Object obj;
        if (this.files.isEmpty() && this.selection != null && this.selection instanceof IStructuredSelection && ((obj = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IFile || obj instanceof IFolder)) {
            this.files.add((IResource)obj);
        }
        if (this.jrConfig == null && this.files.get(0) instanceof IFile) {
            this.jrConfig = JasperReportsConfiguration.getDefaultJRConfig((IFile)((IFile)this.files.get(0)));
        }
    }

    public void dispose() {
        if (this.jrConfig != null) {
            this.jrConfig.dispose();
        }
        super.dispose();
    }

    public void addPages() {
        this.init();
        if (this.files.isEmpty()) {
            FileSelectionPage page0 = new FileSelectionPage(this.jrConfig);
            this.addPage((IWizardPage)page0);
        }
        this.page1 = this.files.size() > 1 || this.files.get(0) instanceof IFolder ? new RFilesLocationPage(this.jrConfig, this.files) : new RFileLocationPage(this.jrConfig, this.files);
        this.addPage((IWizardPage)this.page1);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.page1.refreshFile();
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Saving", -1);
                            List<AMResource> fres = PublishFile2ServerWizard.this.page1.getSelectedNodes();
                            if (fres != null) {
                                ArrayList<String> saved = new ArrayList<String>();
                                int i = 0;
                                while (i < fres.size()) {
                                    if (PublishFile2ServerWizard.this.files.get(i) instanceof IFile) {
                                        IFile f = (IFile)PublishFile2ServerWizard.this.files.get(i);
                                        AMResource fr = fres.get(i);
                                        monitor.subTask(f.toString());
                                        WSClientHelper.save(monitor, fr);
                                        PublishUtil.savePath(f, fr);
                                        saved.add(fr.getValue().getUriString());
                                    }
                                    ++i;
                                }
                                StringBuilder str = new StringBuilder(Messages.Publish_0);
                                for (String mres : saved) {
                                    str.append(mres).append("\n");
                                }
                                UIUtils.showInformation((String)str.toString());
                                AMResource first = fres.get(0);
                                INode n = first.getRoot();
                                if (n != null && n instanceof MServerProfile) {
                                    MServerProfile msp = ServerManager.getServerByUrl(((MServerProfile)n).getValue().getUrl());
                                    ServerManager.selectIfExists(monitor, msp, first);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IWizardPage getStartingPage() {
        return this.getPages()[Math.min(this.startPage, this.getPageCount() - 1)];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof StructuredSelection) {
            if (selection.getFirstElement() instanceof IProject || selection.getFirstElement() instanceof IFile || selection.getFirstElement() instanceof IFolder) {
                this.selection = selection;
                return;
            }
            for (Object obj : selection.toList()) {
                IEditorInput ein;
                if (!(obj instanceof EditPart) || !((ein = SelectionHelper.getActiveJRXMLEditor().getEditorInput()) instanceof FileEditorInput)) continue;
                this.selection = new TreeSelection(new TreePath(new Object[]{((FileEditorInput)ein).getFile()}));
                return;
            }
        }
        this.selection = selection;
    }
}

