/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.model.server.MServers;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public abstract class AFilesLocationPage
extends JSSHelpWizardPage {
    protected TreeViewer treeViewer;
    protected RefreshResourcesAction refreshAction;
    protected JasperReportsConfiguration jConfig;
    protected boolean isFillingInput;
    protected boolean canSuggestID;
    protected List<IResource> files;
    protected boolean isRefresh = false;
    protected boolean skipEvents = false;
    protected MServers servers;

    public AFilesLocationPage(String id, JasperReportsConfiguration jConfig, List<IResource> files) {
        super(id);
        this.jConfig = jConfig;
        this.files = files;
    }

    public void refreshFile() {
    }

    public abstract List<AMResource> getSelectedNodes();

    protected String getContextName() {
        return "com.jaspersoft.studio.doc.select_server";
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.getErrorMessage() == null && this.isPageCompleteLogic();
    }

    protected boolean isPageCompleteLogic() {
        TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
        Object firstElement = ts.getFirstElement();
        return firstElement instanceof AFileResource || firstElement instanceof MFolder;
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setPageComplete(this.isPageComplete());
    }

    protected void performPageChecks() {
        String errorMsg = null;
        this.setErrorMessage(errorMsg);
        this.setPageComplete(errorMsg == null);
    }

    protected void handleSelectionChanged(Object obj) {
    }

    public void fillInput() {
        Display.getDefault().asyncExec(() -> {
            this.isFillingInput = true;
            this.servers = new MServers(null);
            ServerManager.loadServerProfilesCopy(this.servers);
            this.treeViewer.setInput((Object)this.servers);
            this.refreshFile();
            try {
                this.doFillInput();
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
            this.isFillingInput = false;
        });
    }

    protected void doFillInput() throws CoreException {
    }

    protected void look4SelectedUnit(final IFile f) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RFileLocationPage_5, -1);
                    try {
                        try {
                            List<String[]> paths = PublishUtil.loadPath(monitor, f);
                            String suri = null;
                            String spath = null;
                            String suser = null;
                            for (String[] p : paths) {
                                if (p[0].startsWith("JRSUSER.")) {
                                    suser = p[1];
                                    continue;
                                }
                                suri = p[0];
                                spath = p[1];
                            }
                            if (suri != null) {
                                MServerProfile msp = null;
                                for (INode n : AFilesLocationPage.this.servers.getChildren()) {
                                    if (!(n instanceof MServerProfile) || !((MServerProfile)n).getValue().getUrl().equals(suri)) continue;
                                    if (suser != null) {
                                        String[] usr = suser.split("\\|");
                                        if (!((MServerProfile)n).getValue().getUser().equals(usr[0]) || usr.length > 1 && !((MServerProfile)n).getValue().getOrganisation().equals(usr[1])) continue;
                                    }
                                    msp = (MServerProfile)n;
                                    break;
                                }
                                if (msp != null) {
                                    this.selectResource(msp, spath, monitor);
                                }
                            }
                        }
                        catch (Exception ce) {
                            ce.printStackTrace();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }

                private boolean selectResource(MServerProfile msp, String uri, IProgressMonitor monitor) throws Exception {
                    if (monitor.isCanceled()) {
                        return true;
                    }
                    ResourceDescriptor rd = new ResourceDescriptor();
                    rd.setUriString(uri);
                    AMResource mres = WSClientHelper.findSelected(monitor, rd, msp);
                    if (mres == null) {
                        return false;
                    }
                    UIUtils.getDisplay().asyncExec(() -> {
                        AFilesLocationPage.this.skipEvents = true;
                        AFilesLocationPage.this.treeViewer.refresh();
                        AFilesLocationPage.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)mres), true);
                        AFilesLocationPage.this.skipEvents = false;
                    });
                    return true;
                }
            });
        }
        catch (InvocationTargetException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            UIUtils.showError((Throwable)e.getCause());
        }
    }
}

