/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.publish.wizard.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.action.resource.RefreshResourcesAction;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.publish.wizard.page.AFilesLocationPage;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.IDStringValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RFilesLocationPage
extends AFilesLocationPage {
    private TreeViewer bTView;
    private List<AMResource> rs;
    protected ANode pNode;

    public RFilesLocationPage(JasperReportsConfiguration jConfig, List<IResource> files) {
        super("serverfilespublish", jConfig, files);
        this.setTitle(Messages.RUnitLocationPage_title);
        this.setDescription("Select location where files will be published");
    }

    @Override
    public List<AMResource> getSelectedNodes() {
        String puri = "/";
        if (this.pNode instanceof MFolder) {
            puri = String.valueOf(((MFolder)this.pNode).getValue().getUriString()) + "/";
        }
        if (this.pNode instanceof MReportUnit) {
            puri = String.valueOf(((MReportUnit)this.pNode).getValue().getUriString()) + "_files/";
        }
        ArrayList<AMResource> res = new ArrayList<AMResource>();
        for (AMResource f : this.rs) {
            ResourceDescriptor rd = f.getValue();
            rd.setUriString(String.valueOf(puri) + rd.getName());
            res.add(this.getResource(f));
        }
        return res;
    }

    private AMResource getResource(AMResource f) {
        String uri = f.getValue().getUriString();
        for (INode n : this.pNode.getChildren()) {
            if (!(n instanceof AFileResource) || !((AFileResource)n).getValue().getUriString().equals(uri) || !(f instanceof AFileResource)) continue;
            AFileResource fr = (AFileResource)n;
            fr.setFile(((AFileResource)f).getFile());
            return fr;
        }
        f.setParent(this.pNode, -1);
        return f;
    }

    @Override
    public void refreshFile() {
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(composite, 512);
        GridData gd = new GridData(1808);
        sashForm.setLayoutData((Object)gd);
        this.createJRSView((Composite)sashForm);
        this.createFilesView((Composite)sashForm);
        this.fillInput();
    }

    private void createJRSView(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                MFolder node;
                if (parentElement instanceof MFolder && (node = (MFolder)((Object)parentElement)).getChildren() != null && !node.getChildren().isEmpty()) {
                    ArrayList<INode> children = new ArrayList<INode>();
                    for (INode n : node.getChildren()) {
                        children.add(n);
                    }
                    return children.toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(event -> {
            TreeSelection ts = (TreeSelection)event.getSelection();
            Object obj = ts.getFirstElement();
            this.handleSelectionChanged(obj);
        });
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
            Object el = ts.getFirstElement();
            if (el instanceof MFolder || el instanceof MServerProfile || el instanceof MReportUnit) {
                if (this.treeViewer.getExpandedState(el)) {
                    this.treeViewer.collapseToLevel(el, 1);
                } else {
                    if (this.refreshAction == null) {
                        this.refreshAction = new RefreshResourcesAction(this.treeViewer);
                    }
                    if (this.refreshAction.isEnabled()) {
                        this.refreshAction.run();
                    }
                    this.treeViewer.expandToLevel(el, 1);
                }
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){
            private ServerProvider serverProvider;

            public void treeExpanded(final TreeExpansionEvent event) {
                if (!RFilesLocationPage.this.skipEvents) {
                    try {
                        RFilesLocationPage.this.getContainer().run(false, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.Publish2ServerWizard_MonitorName, -1);
                                try {
                                    try {
                                        if (serverProvider == null) {
                                            serverProvider = new ServerProvider();
                                        }
                                        serverProvider.handleTreeEvent(event, monitor);
                                    }
                                    catch (Exception e) {
                                        UIUtils.showError((Throwable)e);
                                        monitor.done();
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        UIUtils.showError((Throwable)e.getCause());
                    }
                    catch (InterruptedException e) {
                        UIUtils.showError((Throwable)e.getCause());
                    }
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
    }

    @Override
    protected void doFillInput() throws CoreException {
        this.rs = new ArrayList<AMResource>();
        for (IResource f : this.files) {
            this.rs.add(this.doGetResource(f, null));
        }
        this.bTView.setInput(this.rs);
    }

    private AMResource doGetResource(IResource r, AMResource parent) throws CoreException {
        String ext;
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setName(IDStringValidator.safeChar((String)r.getName()));
        rd.setLabel(r.getName());
        String string = ext = r.getFileExtension() != null ? r.getFileExtension().toLowerCase() : "";
        if (r instanceof IFolder) {
            rd.setWsType("folder");
            MFolder mf = (MFolder)ResourceFactory.getResource((ANode)parent, rd, -1);
            mf.removeChildren();
            IFolder fd = (IFolder)r;
            IResource[] iResourceArray = fd.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource ff = iResourceArray[n2];
                this.doGetResource(ff, mf);
                ++n2;
            }
            return mf;
        }
        if (ext.equalsIgnoreCase("xml")) {
            rd.setWsType("xml");
        } else if (ext.equalsIgnoreCase("jar") || ext.equalsIgnoreCase("zip")) {
            rd.setWsType("jar");
        } else if (ext.equalsIgnoreCase("jrtx")) {
            rd.setWsType("jrtx");
        } else if (ext.equalsIgnoreCase("css")) {
            rd.setWsType("css");
        } else if (ext.equalsIgnoreCase("jrxml")) {
            rd.setWsType("jrxml");
        } else if (ext.equalsIgnoreCase("json")) {
            rd.setWsType("json");
        } else if (ext.equalsIgnoreCase("properties")) {
            rd.setWsType("prop");
        } else if (ext.equalsIgnoreCase("ttf") || ext.equalsIgnoreCase("eot") || ext.equalsIgnoreCase("woff")) {
            rd.setWsType("font");
        } else if (ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("gif") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp") || ext.equalsIgnoreCase("tiff")) {
            rd.setWsType("img");
        } else {
            rd.setWsType("contentResource");
        }
        AMResource resource = ResourceFactory.getResource((ANode)parent, rd, -1);
        if (r instanceof IFile && resource instanceof AFileResource) {
            ((AFileResource)resource).setFile(((IFile)r).getRawLocation().toFile());
        }
        return resource;
    }

    protected void createFilesView(Composite composite) {
        this.bTView = new TreeViewer(composite, 2052);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.bTView.getTree().setLayoutData((Object)gd);
        this.bTView.setContentProvider((IContentProvider)new ReportTreeContetProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    return ((List)parentElement).toArray();
                }
                return super.getChildren(parentElement);
            }
        });
        this.bTView.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.bTView);
        this.bTView.addSelectionChangedListener(event -> {
            TreeSelection ts = (TreeSelection)event.getSelection();
            Object obj = ts.getFirstElement();
            this.handleSelectionChanged(obj);
        });
        this.bTView.addDoubleClickListener(event -> {
            TreeSelection ts = (TreeSelection)this.bTView.getSelection();
            ts.getFirstElement();
        });
    }

    @Override
    protected void handleSelectionChanged(Object obj) {
        if (this.isRefresh) {
            return;
        }
        this.isRefresh = true;
        if (obj instanceof MReportUnit || obj instanceof MFolder || obj instanceof AFileResource || obj instanceof MServerProfile) {
            this.pNode = (ANode)obj;
        } else {
            this.setPageComplete(false);
        }
        this.performPageChecks();
        this.isRefresh = false;
    }
}

