/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.selector;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.studio.jface.IFileSelection;
import com.jaspersoft.studio.jface.dialogs.FilePreviewSelectionDialog;
import com.jaspersoft.studio.jface.dialogs.FileSelectionDialog;
import com.jaspersoft.studio.jface.dialogs.ImageSelectionDialog;
import com.jaspersoft.studio.jface.dialogs.StyleTemplateSelectionDialog;
import com.jaspersoft.studio.jface.dialogs.SubreportSelectionDialog;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.export.AExporter;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.selector.IFileSelectorServerTypes;
import com.jaspersoft.studio.server.selector.SelectServerWizard;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelector
implements IFileSelection {
    private Composite cmpExpr;
    private FileSelectionDialog dialog;
    private Text txtURL;
    private JasperDesign jd;
    private ModifyListener listener = e -> this.dialog.setFileExpressionText(this.txtURL.getText());

    public void createRadioButton(Composite parent, final FileSelectionDialog d, JasperDesign jd) {
        this.dialog = d;
        this.jd = jd;
        final Button btnExpression = new Button(parent, 16);
        btnExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnExpression.getSelection()) {
                    FileSelector.this.dialog.changeFileSelectionMode((Control)FileSelector.this.cmpExpr);
                    d.setAllowValidation(false);
                }
            }
        });
        btnExpression.setText(Messages.FileSelector_0);
    }

    public void changeSelectionMode(Control newTopControl) {
        this.txtURL.setText("");
    }

    public void createFileSelectionContainer(Composite parent) {
        this.cmpExpr = new Composite(parent, 0);
        this.cmpExpr.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(this.cmpExpr, 0);
        lbl.setText(Messages.FileSelector_0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.txtURL = new Text(this.cmpExpr, 2048);
        this.txtURL.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtURL.addModifyListener(this.listener);
        Button btn = new Button(this.cmpExpr, 8);
        btn.setText("...");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String servUser;
                String servURL = FileSelector.this.jd.getProperty("ireport.jasperserver.url");
                MServerProfile msp = ServerManager.getServerByUrl(servURL, servUser = FileSelector.this.jd.getProperty("ireport.jasperserver.user"));
                if (msp == null) {
                    SelectServerWizard wizard = new SelectServerWizard();
                    WizardDialog w = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
                    if (w.open() == 0) {
                        msp = wizard.getValue();
                        try {
                            FileSelector.this.jd.setProperty("ireport.jasperserver.url", msp.getValue().getUrl());
                            FileSelector.this.jd.setProperty("ireport.jasperserver.user", AExporter.encodeUsr(msp.getValue()));
                        }
                        catch (MalformedURLException | URISyntaxException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                if (msp != null) {
                    this.showFindDialog(msp);
                }
            }

            protected void showFindDialog(MServerProfile msp) {
                if (msp.isSupported(Feature.SEARCHREPOSITORY)) {
                    boolean t = msp.getWsClient().getServerInfo().getVersion().compareTo("5.5") >= 0;
                    String[] incl = null;
                    if (FileSelector.this.dialog instanceof SubreportSelectionDialog) {
                        incl = new String[]{t ? ClientFile.FileType.jrxml.name() : "file"};
                    } else if (FileSelector.this.dialog instanceof ImageSelectionDialog) {
                        incl = new String[]{t ? ClientFile.FileType.img.name() : "file"};
                    } else if (FileSelector.this.dialog instanceof StyleTemplateSelectionDialog) {
                        incl = new String[]{t ? ClientFile.FileType.jrtx.name() : "file"};
                    } else if (FileSelector.this.dialog instanceof IFileSelectorServerTypes) {
                        incl = ((IFileSelectorServerTypes)FileSelector.this.dialog).getServerSupportedTypes();
                    }
                    ResourceDescriptor rd = FindResourceJob.doFindResource(msp, incl, null, true);
                    if (rd != null) {
                        FileSelector.this.dialog.setFileExpressionText("repo:" + rd.getUriString());
                        FileSelector.this.txtURL.removeModifyListener(FileSelector.this.listener);
                        FileSelector.this.txtURL.setText(rd.getUriString());
                        FileSelector.this.txtURL.addModifyListener(FileSelector.this.listener);
                        if (FileSelector.this.dialog instanceof FilePreviewSelectionDialog) {
                            ((FilePreviewSelectionDialog)FileSelector.this.dialog).loadImagePreview();
                        }
                    }
                } else {
                    AMResource rs;
                    RepositoryDialog rd = new RepositoryDialog(UIUtils.getShell(), (INode)msp){

                        @Override
                        public boolean isResourceCompatible(AMResource r) {
                            if ((this).FileSelector.this.dialog instanceof SubreportSelectionDialog) {
                                return r.getValue().getWsType().equals("jrxml");
                            }
                            if ((this).FileSelector.this.dialog instanceof ImageSelectionDialog) {
                                return r.getValue().getWsType().equals("img");
                            }
                            if ((this).FileSelector.this.dialog instanceof StyleTemplateSelectionDialog) {
                                return r.getValue().getWsType().equals("jrtx");
                            }
                            if ((this).FileSelector.this.dialog instanceof IFileSelectorServerTypes) {
                                return ((IFileSelectorServerTypes)(this).FileSelector.this.dialog).isResourceCompatible(r.getValue().getWsType());
                            }
                            return true;
                        }
                    };
                    if (rd.open() == 0 && (rs = rd.getResource()) != null) {
                        FileSelector.this.dialog.setFileExpressionText("repo:" + rs.getValue().getUriString());
                        FileSelector.this.txtURL.removeModifyListener(FileSelector.this.listener);
                        FileSelector.this.txtURL.setText(rs.getValue().getUriString());
                        FileSelector.this.txtURL.addModifyListener(FileSelector.this.listener);
                        if (FileSelector.this.dialog instanceof FilePreviewSelectionDialog) {
                            ((FilePreviewSelectionDialog)FileSelector.this.dialog).loadImagePreview();
                        }
                    }
                }
            }
        });
    }
}

