/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.utils;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.studio.server.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class ResourceDescriptorUtil {
    public static boolean isReportMain(IFile file) throws CoreException {
        String val = file.getPersistentProperty(new QualifiedName("com.jaspersoft.studio.server", "ireport.jasperserver.report.ismain"));
        boolean b = val == null || val.isEmpty();
        try {
            b = b || Boolean.parseBoolean(val);
        }
        catch (Exception e) {
            Activator.getDefault().logTrace(e);
        }
        return b;
    }

    public static ResourceProperty getProperty(String name, List<ResourceProperty> props) {
        for (ResourceProperty rp : props) {
            if (!rp.getName().equals(name)) continue;
            return rp;
        }
        return null;
    }

    public static void setProposedResourceDescriptorIDAndName(List<ResourceDescriptor> siblingDescriptors, ResourceDescriptor target, String suggestedID, String suggestedName) {
        ArrayList<String> ids = new ArrayList<String>(siblingDescriptors.size());
        ArrayList<String> names = new ArrayList<String>(siblingDescriptors.size());
        for (ResourceDescriptor rd : siblingDescriptors) {
            ids.add(rd.getName());
            names.add(rd.getLabel());
        }
        if (!ids.contains(suggestedID)) {
            target.setName(suggestedID);
        } else {
            int i = 1;
            while (i < 1000) {
                String newID = String.valueOf(suggestedID) + "_" + i;
                if (!ids.contains(newID)) {
                    target.setName(newID);
                    break;
                }
                ++i;
            }
        }
        if (!names.contains(suggestedName)) {
            target.setLabel(suggestedName);
        } else {
            int i = 1;
            while (i < 1000) {
                String newName = String.valueOf(suggestedName) + "_" + i;
                if (!names.contains(newName)) {
                    target.setLabel(newName);
                    break;
                }
                ++i;
            }
        }
    }
}

