/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.utils;

import com.jaspersoft.studio.server.messages.Messages;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final int MAX_LENGTH_NAME = 100;
    public static final int MAX_LENGTH_LABEL = 100;
    public static final int MAX_LENGTH_DESC = 250;
    private static final Pattern PATTERN_NAME = Pattern.compile("(\\p{L}|\\p{N}|(\\_)|(\\.)|(\\-)|[;@])+");

    public static String validateName(String name) {
        if (name == null || name.length() == 0) {
            return Messages.ValidationUtils_NameEmptyErr;
        }
        Matcher mat = PATTERN_NAME.matcher(name.trim());
        if (!mat.matches()) {
            return Messages.ValidationUtils_NameInvalidCharsErr;
        }
        if (name.trim().length() > 100) {
            return MessageFormat.format(Messages.ValidationUtils_NameTooLongErr, new Integer(100));
        }
        return null;
    }

    public static String validateLabel(String name) {
        if (name == null || name.length() == 0) {
            return Messages.ValidationUtils_LabelEmptyErr;
        }
        if (name.trim().length() > 100) {
            return MessageFormat.format(Messages.ValidationUtils_LabelTooLongErr, new Integer(100));
        }
        return null;
    }

    public static String validateDesc(String name) {
        if (name != null && name.trim().length() > 250) {
            return MessageFormat.format(Messages.ValidationUtils_DescriptionTooLongErr, new Integer(250));
        }
        return null;
    }
}

