/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.find;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ServerProvider;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.wizard.find.FindResourceWizard;
import com.jaspersoft.studio.server.wizard.find.FindWizardDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;

public class FindResourceJob {
    public static ResourceDescriptor doFindResource(MServerProfile msp, String[] in, String[] excl) {
        return FindResourceJob.doFindResource(msp, in, excl, false, null);
    }

    public static ResourceDescriptor doFindResource(MServerProfile msp, String[] in, String[] excl, boolean containedResource) {
        return FindResourceJob.doFindResource(msp, in, excl, containedResource, null);
    }

    public static ResourceDescriptor doFindResource(MServerProfile msp, String[] in, String[] excl, boolean containedResource, String defaultName) {
        return FindResourceJob.doFindResource(UIUtils.getShell(), msp, in, excl, containedResource, defaultName);
    }

    public static ResourceDescriptor doFindResource(Shell shell, MServerProfile msp, String[] in, String[] excl, boolean containedResource, String defaultName) {
        FindResourceWizard wizard = new FindResourceWizard(msp, containedResource);
        wizard.setFilterTypes(in, excl);
        wizard.setDefaultName(defaultName);
        FindWizardDialog dialog = new FindWizardDialog(shell, (IWizard)wizard);
        dialog.setHelpAvailable(false);
        dialog.create();
        if (dialog.open() == 0) {
            return wizard.getValue();
        }
        return null;
    }

    public static void doFindResource(ServerProvider sp, TreeViewer treeViewer) {
        FindResourceJob.doFindResource(sp, treeViewer, false);
    }

    public static void doFindResource(ServerProvider sp, TreeViewer treeViewer, boolean containedResource) {
        INode n;
        TreeSelection ts = (TreeSelection)treeViewer.getSelection();
        Object el = ts.getFirstElement();
        MServerProfile msp = null;
        if (el instanceof MServerProfile) {
            msp = (MServerProfile)((Object)el);
        } else if (el instanceof AMResource && (n = ((AMResource)((Object)el)).getRoot()) != null && n instanceof MServerProfile) {
            msp = (MServerProfile)n;
        }
        if (msp != null) {
            ResourceDescriptor rd;
            FindResourceWizard wizard = new FindResourceWizard(msp, containedResource);
            FindWizardDialog dialog = new FindWizardDialog(UIUtils.getShell(), (IWizard)wizard);
            dialog.setHelpAvailable(false);
            dialog.create();
            if (dialog.open() == 0 && (rd = wizard.getValue()) != null) {
                FindResourceJob.selectResource(sp, msp, rd, treeViewer);
            }
        }
    }

    public static void selectResource(final ServerProvider sp, final MServerProfile msp, final ResourceDescriptor rd, final TreeViewer treeViewer) {
        Job job = new Job(Messages.FindResourceJob_0){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        AMResource mr = WSClientHelper.findSelected(monitor, rd, msp);
                        if (mr != null) {
                            UIUtils.getDisplay().asyncExec(() -> {
                                try {
                                    sp.setSkipLazyLoad(true);
                                    treeViewer.refresh(true);
                                    treeViewer.setSelection((ISelection)new StructuredSelection((Object)mr));
                                }
                                finally {
                                    sp.setSkipLazyLoad(false);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        job.setPriority(20);
        job.setSystem(false);
        job.setUser(true);
        job.schedule();
    }
}

