/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.find;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.AFinderUI;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MContentResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryComposite;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.wizard.find.FindWizardDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.BiMap;
import jersey.repackaged.com.google.common.collect.HashBiMap;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.SWTResourceManager;

public class FindResourcePage
extends WizardPage {
    private FinderUI finderUI;
    private String[] itypes;
    private String[] etypes;
    private String name;
    private boolean containedResource = false;
    private MServerProfile sp;
    private BiMap<String, Button> typesMap = HashBiMap.create();
    private ResourceDescriptor value;
    private Text txt;
    private List<ClientResourceLookup> res;
    private TableViewer viewer;
    private static Set<String> dsTypes = WsTypes.INST().getDatasources();
    private SelectionListener typeListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button bhiden = (Button)e.getSource();
            String type = (String)FindResourcePage.this.typesMap.inverse().get((Object)bhiden);
            if (!bhiden.getSelection()) {
                FindResourcePage.this.ball.setSelection(false);
                if (dsTypes.contains(type)) {
                    FindResourcePage.this.bds.setSelection(false);
                }
            }
            FindResourcePage.this.setTypes();
        }
    };
    private Button bds;
    private Button ball;
    private int started = 0;
    private boolean ended = true;
    private CTabFolder tabFolder;
    private Button bft;

    public void setDefaultName(String name) {
        this.name = name;
    }

    public void setFilterTypes(String[] in, String[] excl) {
        this.itypes = in;
        this.etypes = excl;
        List<String> tps = this.finderUI.getTypes();
        tps.clear();
        if (this.itypes != null) {
            Collections.addAll(tps, this.itypes);
        }
        if (this.etypes != null) {
            String[] stringArray = this.etypes;
            int n = this.etypes.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (tps.contains(t)) {
                    tps.remove(t);
                }
                ++n2;
            }
        }
    }

    protected FindResourcePage(MServerProfile sp, boolean containedResource) {
        super("findresource");
        this.containedResource = containedResource;
        this.setTitle(Messages.FindResourcePage_1);
        this.setDescription(Messages.FindResourcePage_2);
        MServerProfile msp = ServerManager.getMServerProfileCopy(sp);
        if (msp == null) {
            msp = sp;
        }
        this.finderUI = new FinderUI(msp);
        this.sp = sp;
    }

    public void createControl(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)cmp);
        new Label(cmp, 0).setText(Messages.FindResourcePage_3);
        this.txt = new Text(cmp, 2048);
        this.txt.setLayoutData((Object)new GridData(768));
        this.txt.addModifyListener(e -> {
            this.tabFolder.setSelection(1);
            this.doSearch();
        });
        Button b = new Button(cmp, 8);
        b.setText(Messages.FindResourcePage_4);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindResourcePage.this.tabFolder.setSelection(1);
                FindResourcePage.this.doSearch();
            }
        });
        if (this.itypes == null && this.etypes == null) {
            Section expcmp = new Section(cmp, 4);
            expcmp.setTitleBarBackground(SWTResourceManager.getColor((int)39));
            expcmp.setText(Messages.FindResourcePage_5);
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 3;
            gd.verticalIndent = 3;
            expcmp.setLayoutData((Object)gd);
            expcmp.setExpanded(false);
            Composite scmp = new Composite((Composite)expcmp, 0);
            scmp.setLayout((Layout)new GridLayout(3, false));
            Map<String, String> typeNames = this.createAllFilters(scmp);
            this.createDatasourceFilters(scmp, typeNames);
            this.createFileTypeFilters(scmp, typeNames);
            expcmp.setClient((Control)scmp);
            expcmp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    UIUtils.relayoutDialog((Shell)FindResourcePage.this.getShell(), (int)0, (int)-1);
                }
            });
        }
        this.tabFolder = new CTabFolder(cmp, 0x800080);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 300;
        gd.widthHint = 500;
        this.tabFolder.setLayoutData((Object)gd);
        this.createTreeView(this.tabFolder);
        this.createListView(this.tabFolder);
        this.tabFolder.setSelection(0);
        if (!Misc.isNullOrEmpty((String)this.name)) {
            UIUtils.getDisplay().asyncExec(() -> this.txt.setText(this.name));
        }
        this.txt.setFocus();
        this.setPageComplete(false);
    }

    private Map<String, String> createAllFilters(Composite scmp) {
        Composite dsCmp = new Composite(scmp, 0);
        dsCmp.setLayout((Layout)new GridLayout(2, false));
        dsCmp.setLayoutData((Object)new GridData(2));
        this.ball = new Button(dsCmp, 32);
        this.ball.setText(Messages.FindResourcePage_6);
        this.ball.setSelection(true);
        this.ball.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = FindResourcePage.this.ball.getSelection();
                for (Button b : FindResourcePage.this.typesMap.values()) {
                    b.setSelection(sel);
                }
                FindResourcePage.this.bds.setSelection(sel);
                FindResourcePage.this.bft.setSelection(sel);
                FindResourcePage.this.finderUI.getTypes().clear();
            }
        });
        Label lbl = new Label(dsCmp, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        Map<String, String> typeNames = ResourceFactory.getTypeNames();
        for (String rtype : typeNames.keySet()) {
            if (dsTypes.contains(rtype)) continue;
            Button bhiden = new Button(dsCmp, 32);
            bhiden.setText(typeNames.get(rtype));
            bhiden.setSelection(true);
            bhiden.setToolTipText(rtype);
            this.typesMap.put((Object)rtype, (Object)bhiden);
            bhiden.addSelectionListener(this.typeListener);
        }
        return typeNames;
    }

    private Map<String, String> createFileTypeFilters(Composite scmp, Map<String, String> typeNames) {
        if (this.sp.getWsClient().getServerInfo().getVersion().compareTo("5.5") >= 0) {
            Composite dsCmp = new Composite(scmp, 0);
            dsCmp.setLayout((Layout)new GridLayout(3, false));
            dsCmp.setLayoutData((Object)new GridData(2));
            this.bft = new Button(dsCmp, 32);
            this.bft.setText("Files By Type");
            this.bft.setSelection(true);
            this.bft.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean sel = FindResourcePage.this.bft.getSelection();
                    block0: for (Button b : FindResourcePage.this.typesMap.values()) {
                        ClientFile.FileType[] fileTypeArray = ClientFile.FileType.values();
                        int n = fileTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ClientFile.FileType ft = fileTypeArray[n2];
                            if (ft.name().equalsIgnoreCase(b.getText())) {
                                b.setSelection(sel);
                                continue block0;
                            }
                            ++n2;
                        }
                    }
                    if (!sel) {
                        FindResourcePage.this.ball.setSelection(false);
                    }
                    FindResourcePage.this.finderUI.getTypes().clear();
                    FindResourcePage.this.setTypes();
                }
            });
            Label lbl = new Label(dsCmp, 258);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            lbl.setLayoutData((Object)gd);
            ClientFile.FileType[] fileTypeArray = ClientFile.FileType.values();
            int n = fileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClientFile.FileType type = fileTypeArray[n2];
                Button bhiden = new Button(dsCmp, 32);
                bhiden.setText(type.name());
                bhiden.setSelection(true);
                bhiden.setToolTipText(type.name());
                this.typesMap.put((Object)type.name(), (Object)bhiden);
                bhiden.addSelectionListener(this.typeListener);
                ++n2;
            }
        }
        return typeNames;
    }

    private void createDatasourceFilters(Composite scmp, Map<String, String> typeNames) {
        Composite dsCmp = new Composite(scmp, 0);
        dsCmp.setLayout((Layout)new GridLayout(2, false));
        dsCmp.setLayoutData((Object)new GridData(2));
        this.bds = new Button(dsCmp, 32);
        this.bds.setText(Messages.FindResourcePage_7);
        this.bds.setSelection(true);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.bds.setLayoutData((Object)gd);
        this.bds.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = FindResourcePage.this.bds.getSelection();
                for (Button b : FindResourcePage.this.typesMap.values()) {
                    String v = (String)FindResourcePage.this.typesMap.inverse().get((Object)b);
                    if (v == null || !dsTypes.contains(v)) continue;
                    b.setSelection(sel);
                }
                if (!sel) {
                    FindResourcePage.this.ball.setSelection(false);
                }
                FindResourcePage.this.setTypes();
            }
        });
        Label lbl = new Label(dsCmp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        for (String rtype : dsTypes) {
            if (!typeNames.containsKey(rtype)) continue;
            Button bhiden = new Button(dsCmp, 32);
            bhiden.setText(Misc.nvl((Object)typeNames.get(rtype), (String)rtype));
            bhiden.setSelection(true);
            bhiden.setToolTipText(rtype);
            this.typesMap.put((Object)rtype, (Object)bhiden);
            bhiden.addSelectionListener(this.typeListener);
        }
    }

    private void createTreeView(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText("Tree");
        RepositoryComposite rcom = new RepositoryComposite((Composite)tabFolder, 0, (INode)this.finderUI.getServerProfile(), false){

            @Override
            protected void okPressed() {
                ((FindWizardDialog)FindResourcePage.this.getContainer()).finishPressed();
            }

            @Override
            protected void setOkButtonEnabled(boolean resCompatible) {
                FindResourcePage.this.setPageComplete(resCompatible);
            }

            @Override
            protected void createReadRepositoryJob() {
                try {
                    FindResourcePage.this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            this.doReadRepository(monitor);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    UIUtils.showError((Throwable)e.getCause());
                }
            }

            @Override
            public boolean isResourceCompatible(AMResource r) {
                if (Misc.isNullOrEmpty(FindResourcePage.this.finderUI.getTypes())) {
                    return true;
                }
                if (!FindResourcePage.this.finderUI.isShowHidden() && !FindResourcePage.this.containedResource && r.getValue().getParentFolder().endsWith("_files")) {
                    return false;
                }
                if (r instanceof MContentResource) {
                    try {
                        WSClientHelper.refreshResource(r, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String type = WsTypes.INST().toRestType(r.getValue().getWsType());
                String ftype = WsTypes.INST().toRestFileType(r.getValue().getWsType()).toString();
                for (String t : FindResourcePage.this.finderUI.getTypes()) {
                    if ("file".equals(type) && t.equals(ftype)) {
                        return true;
                    }
                    if (!t.equals(type)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void setResource(AMResource res) {
                super.setResource(res);
                FindResourcePage.this.value = res.getValue();
            }
        };
        rcom.setLayoutData(new GridData(1808));
        bptab.setControl((Control)rcom);
    }

    private void createListView(CTabFolder tabFolder) {
        CTabItem bptab = new CTabItem(tabFolder, 0);
        bptab.setText("List");
        Composite tableComposite = new Composite((Composite)tabFolder, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        bptab.setControl((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.viewer = new TableViewer(tableComposite, 66308);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                ClientResourceLookup p = (ClientResourceLookup)cell.getElement();
                cell.setText(String.valueOf(p.getLabel()) + " : " + p.getUri());
                StyleRange myStyledRange = new StyleRange(p.getLabel().length() + 3, cell.getText().length(), Display.getCurrent().getSystemColor(15), null);
                StyleRange[] range = new StyleRange[]{myStyledRange};
                cell.setStyleRanges(range);
                cell.setImage(ResourceFactory.getIcon(p.getResourceType()));
                super.update(cell);
            }

            public String getToolTipText(Object element) {
                ClientResourceLookup p = (ClientResourceLookup)element;
                String tt = p.getLabel();
                tt = String.valueOf(tt) + "\n" + Messages.FindResourcePage_10 + p.getDescription();
                tt = String.valueOf(tt) + "\n" + Messages.FindResourcePage_uri + p.getUri();
                tt = String.valueOf(tt) + "\n" + Messages.FindResourcePage_14 + p.getResourceType();
                tt = String.valueOf(tt) + "\n" + Messages.FindResourcePage_16 + p.getCreationDate();
                tt = String.valueOf(tt) + "\n" + Messages.FindResourcePage_18 + p.getUpdateDate();
                return tt;
            }
        });
        this.viewer.addDoubleClickListener(event -> ((FindWizardDialog)this.getContainer()).finishPressed());
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        final Table table = this.viewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindResourcePage.this.res != null) {
                    try {
                        int[] sel = table.getSelectionIndices();
                        if (sel.length > 0) {
                            FindResourcePage.this.value = WSClientHelper.toResourceDescriptor(FindResourcePage.this.finderUI.getServerProfile(), (ClientResource)FindResourcePage.this.res.get(sel[0]));
                        }
                        if (FindResourcePage.this.value != null) {
                            FindResourcePage.this.setPageComplete(true);
                        }
                    }
                    catch (Exception e1) {
                        UIUtils.showError((Throwable)e1);
                    }
                }
            }
        });
    }

    public ResourceDescriptor getValue() {
        return this.value;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.getValue() != null;
    }

    private void setTypes() {
        List<String> tps = this.finderUI.getTypes();
        tps.clear();
        for (Button b : this.typesMap.values()) {
            if (!b.getSelection()) continue;
            tps.add((String)this.typesMap.inverse().get((Object)b));
        }
    }

    private void doSearch() {
        this.finderUI.setText(this.txt.getText());
        ++this.started;
        if (this.ended) {
            this.ended = false;
            this.search();
        }
    }

    private void search() {
        if (SystemUtils.IS_OS_WINDOWS) {
            new Thread(() -> {
                try {
                    WSClientHelper.findResources((IProgressMonitor)new NullProgressMonitor(), this.finderUI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } else {
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.FindResourcePage_19, -1);
                        try {
                            try {
                                WSClientHelper.findResources(monitor, FindResourcePage.this.finderUI);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp();
    }

    class FinderUI
    extends AFinderUI {
        public FinderUI(MServerProfile sp) {
            super(sp);
        }

        @Override
        public void showResults(List<ClientResourceLookup> res) {
            FindResourcePage.this.res = res;
            UIUtils.getDisplay().asyncExec(() -> {
                FindResourcePage.this.setPageComplete(res != null);
                if (res != null) {
                    FindResourcePage.this.viewer.setInput((Object)res);
                } else {
                    FindResourcePage.this.viewer.setInput(Collections.emptyList());
                }
                FindResourcePage.this.value = null;
                FindResourcePage.this.setPageComplete(false);
                FindResourcePage.this.ended = true;
                --FindResourcePage.this.started;
                if (FindResourcePage.this.started > 0) {
                    FindResourcePage.this.started = 0;
                    FindResourcePage.this.doSearch();
                }
            });
        }
    }
}

