/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.utils.IPageCompleteListener;
import com.jaspersoft.studio.server.wizard.resource.EditResourcePage;
import com.jaspersoft.studio.server.wizard.resource.NewResourcePage;
import com.jaspersoft.studio.wizards.AWizardPage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class APageContent
implements IPageCompleteListener {
    protected AWizardPage page;
    protected ANode pnode;
    protected AMResource res;
    protected DataBindingContext bindingContext;
    private boolean isPageComplete = true;
    protected boolean refresh = false;

    public APageContent(ANode parent, AMResource resource) {
        this(parent, resource, new DataBindingContext());
    }

    public APageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        this.res = resource;
        this.pnode = parent;
        this.bindingContext = bindingContext;
    }

    protected IConnection getWsClient() {
        IConnection con = this.res.getWsClient();
        if (con == null) {
            if (this.pnode instanceof AMResource) {
                con = ((AMResource)this.pnode).getWsClient();
            } else if (this.pnode instanceof MServerProfile) {
                con = ((MServerProfile)this.pnode).getWsClient();
            }
        }
        return con;
    }

    public void setBindingContext(DataBindingContext bindingContext) {
        this.bindingContext = bindingContext;
        this.rebind();
    }

    protected abstract void rebind();

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public abstract String getName();

    public abstract String getPageName();

    public abstract Control createContent(Composite var1);

    public static IWizardPage[] getPages(AMResource res, APageContent ... rcontent) {
        if (res.getValue() != null && res.getValue().getIsNew()) {
            IWizardPage[] pages = new IWizardPage[rcontent.length];
            int i = 0;
            while (i < pages.length) {
                pages[i] = new NewResourcePage(rcontent[i]);
                ++i;
            }
            return pages;
        }
        return new IWizardPage[]{new EditResourcePage(rcontent)};
    }

    public void setPage(AWizardPage page) {
        this.page = page;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    @Override
    public void pageCompleted(boolean completed) {
        if (this.refresh) {
            return;
        }
        this.refresh = true;
        this.setPageComplete(completed);
        if (completed) {
            this.page.setErrorMessage(null);
        } else {
            this.page.setErrorMessage(Messages.APageContent_0);
        }
        this.refresh = false;
    }

    public void setPageComplete(boolean complete) {
        this.isPageComplete = complete;
        this.page.setPageComplete(complete);
    }

    public String getHelpContext() {
        return null;
    }

    public void dispose() {
    }
}

