/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.combomenu.ComboItem;
import com.jaspersoft.studio.property.combomenu.ComboItemAction;
import com.jaspersoft.studio.property.combomenu.ComboMenuViewer;
import com.jaspersoft.studio.property.section.widgets.SPRWPopUpCombo;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AFileResource;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.NotEmptyFileValidator;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;

public abstract class AFileResourcePageContent
extends APageContent {
    protected Text trefuri;
    protected static ComboItem defaultComboItem = new ComboItem(Messages.AFileResourcePageContent_upDownButtonTitle, true, Activator.getDefault().getImage("icons/up-down-arrows.png"), 0, (Object)0, (Object)0);

    public AFileResourcePageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public AFileResourcePageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    protected void createExportButton(Composite parent) {
        if (!this.res.getValue().getIsNew()) {
            Button bexport = new Button(parent, 16392);
            bexport.setText(Messages.AFileResourcePage_downloadfilebutton);
            bexport.setImage(Activator.getDefault().getImage("icons/drive-download.png"));
            bexport.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IPath path;
                    SaveAsDialog saveAsDialog = new SaveAsDialog(UIUtils.getShell());
                    String fname = AFileResourcePageContent.this.res.getValue().getName();
                    if (!fname.contains(".")) {
                        fname = String.valueOf(fname) + "." + ((AFileResource)AFileResourcePageContent.this.res).getDefaultFileExtension();
                    }
                    saveAsDialog.setOriginalName(fname);
                    if (saveAsDialog.open() == 0 && (path = saveAsDialog.getResult()) != null) {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        if (file != null) {
                            AFileResourcePageContent.this.doSaveFile(file.getLocation().toPortableString());
                        }
                        try {
                            file.getParent().refreshLocal(2, null);
                        }
                        catch (CoreException e1) {
                            UIUtils.showError((Throwable)e1);
                        }
                    }
                }
            });
        }
    }

    protected void createImportButton(Composite parent) {
        Button bimport = new Button(parent, 16392);
        bimport.setText(Messages.AFileResourcePage_uploadfile);
        bimport.setImage(Activator.getDefault().getImage("icons/drive-upload.png"));
        bimport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename = AFileResourcePageContent.this.getFileDialog();
                if (filename != null) {
                    ((AFileResource)AFileResourcePageContent.this.res).setFile(new File(filename));
                }
                AFileResourcePageContent.this.handleFileChange();
            }
        });
    }

    protected void createTextArea(Composite parent) {
        this.trefuri = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 10;
        this.trefuri.setLayoutData((Object)gd);
    }

    @Override
    protected void rebind() {
        JasperReportsConfiguration jrConfig = this.res.getJasperConfiguration();
        if (jrConfig == null) {
            jrConfig = JasperReportsConfiguration.getDefaultInstance();
        }
        Binding binding = null;
        if (this.res.getValue().getIsNew()) {
            NotEmptyFileValidator nefValidator = new NotEmptyFileValidator((JasperReportsContext)jrConfig);
            binding = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.trefuri), PojoProperties.value((String)"fileName").observe((Object)new FileProxy((AFileResource)this.res)), new UpdateValueStrategy().setAfterConvertValidator((IValidator)nefValidator), null);
            nefValidator.setBinding(binding);
        } else {
            binding = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.trefuri), PojoProperties.value((String)"fileName").observe((Object)new FileProxy((AFileResource)this.res)));
        }
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512, null, (ControlDecorationUpdater)new ControlDecorationUpdater());
    }

    protected void createComboMenuButton(Composite parent) {
        List<ComboItem> itemsList = this.getItemsList();
        final ComboMenuViewer multipleButton = new ComboMenuViewer(parent, 0, SPRWPopUpCombo.getLongest(itemsList));
        multipleButton.addSelectionListener(new ComboItemAction(){

            public void exec() {
                AFileResourcePageContent.this.buttonSelected((Integer)multipleButton.getSelectionValue());
            }
        });
        multipleButton.setItems(itemsList);
        multipleButton.disableSelectedItemUpdate(true);
        multipleButton.disableSelectedEmphasis(true);
        multipleButton.select(defaultComboItem);
    }

    protected List<ComboItem> getItemsList() {
        ArrayList<ComboItem> itemsList = new ArrayList<ComboItem>();
        if (this.res.getRoot() instanceof MServerProfile && !this.res.getValue().getIsNew()) {
            itemsList.add(new ComboItem(Messages.AFileResourcePage_downloadfilebutton, true, Activator.getDefault().getImage("icons/drive-download.png"), 0, (Object)0, (Object)0));
        }
        itemsList.add(new ComboItem(Messages.AFileResourcePageContent_uploadFromFS, true, Activator.getDefault().getImage("icons/drive-upload.png"), 1, (Object)1, (Object)1));
        itemsList.add(new ComboItem(Messages.JrxmlPageContent_uploadFromRepo, true, Activator.getDefault().getImage("icons/drive-upload.png"), 2, (Object)2, (Object)2));
        return itemsList;
    }

    protected void buttonSelected(Integer selectionValue) {
        if (selectionValue.equals(0)) {
            IPath path;
            SaveAsDialog saveAsDialog = new SaveAsDialog(UIUtils.getShell());
            String fname = this.res.getValue().getName();
            if (!fname.contains(".")) {
                fname = String.valueOf(fname) + "." + ((AFileResource)this.res).getDefaultFileExtension();
            }
            saveAsDialog.setOriginalName(fname);
            if (saveAsDialog.open() == 0 && (path = saveAsDialog.getResult()) != null) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                if (file != null) {
                    this.doSaveFile(file.getLocation().toPortableString());
                }
                try {
                    file.getParent().refreshLocal(2, null);
                }
                catch (CoreException e1) {
                    UIUtils.showError((Throwable)e1);
                }
            }
        } else if (selectionValue.equals(1)) {
            String filename = this.getFileDialog();
            if (filename != null) {
                ((AFileResource)this.res).setFile(new File(filename));
            }
            this.handleFileChange();
        } else if (selectionValue.equals(2)) {
            String filename = this.getResourceDialog();
            if (filename != null) {
                ((AFileResource)this.res).setFile(new File(filename));
            }
            this.handleFileChange();
        }
    }

    protected String getIntialPattern() {
        String[] f = this.getFilter();
        if (f != null && f.length > 0) {
            return f[f.length - 1];
        }
        return ".*";
    }

    protected String getResourceDialog() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.trefuri.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("");
        dialog.setInitialPattern(this.getIntialPattern());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return file.getLocation().toPortableString();
        }
        return null;
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createTextArea(composite);
        this.createComboMenuButton(composite);
        this.createFileTab(composite);
        this.handleFileChange();
        this.rebind();
        return composite;
    }

    protected void handleFileChange() {
        this.trefuri.setText(Misc.nvl((String)((AFileResource)this.res).getFileName()));
    }

    protected void createFileTab(Composite tabFolder) {
    }

    @Override
    public String getHelpContext() {
        return "com.jaspersoft.studio.doc.editGenericFile";
    }

    protected abstract String[] getFilter();

    protected void doSaveFile(String filename) {
        if (filename != null) {
            try {
                WSClientHelper.getResource((IProgressMonitor)new NullProgressMonitor(), (ANode)this.res, this.res.getValue(), filename);
                File file = new File(filename);
                int dotPos = filename.lastIndexOf(".");
                String strFilename = filename.substring(0, dotPos);
                ImageTypeEnum itype = JRTypeSniffer.getImageTypeValue((byte[])FileUtils.getBytes((File)file));
                if (itype == ImageTypeEnum.GIF) {
                    file = FileUtils.fileRenamed((File)file, (String)strFilename, (String)".gif");
                } else if (itype == ImageTypeEnum.JPEG) {
                    file = FileUtils.fileRenamed((File)file, (String)strFilename, (String)".jpeg");
                } else if (itype == ImageTypeEnum.PNG) {
                    file = FileUtils.fileRenamed((File)file, (String)strFilename, (String)".png");
                } else if (itype == ImageTypeEnum.TIFF) {
                    file = FileUtils.fileRenamed((File)file, (String)strFilename, (String)".tiff");
                }
                ((AFileResource)this.res).setFile(file);
            }
            catch (Exception e1) {
                UIUtils.showError((Throwable)e1);
            }
            this.handleFileChange();
        }
    }

    protected String getFileDialog() {
        FileDialog fd = new FileDialog(UIUtils.getShell(), 4096);
        fd.setFilterExtensions(this.getFilter());
        fd.setText(Messages.AFileResourcePage_selectresourcefile);
        String filename = fd.open();
        return filename;
    }

    private class FileProxy {
        private AFileResource fres;

        public FileProxy(AFileResource fres) {
            this.fres = fres;
        }

        public String getFileName() {
            return this.fres.getFileName();
        }

        public void setFileName(String fileName) {
            if (Misc.isNullOrEmpty((String)fileName)) {
                this.fres.setFile(null);
            } else {
                this.fres.setFile(new File(fileName));
            }
        }
    }
}

