/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.util.ModelVisitor;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.server.Activator;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MContentResource;
import com.jaspersoft.studio.server.model.MDataType;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MInputControl;
import com.jaspersoft.studio.server.model.MJar;
import com.jaspersoft.studio.server.model.MJrxml;
import com.jaspersoft.studio.server.model.MListOfValues;
import com.jaspersoft.studio.server.model.MRAccessGrantSchema;
import com.jaspersoft.studio.server.model.MRAzureCertificate;
import com.jaspersoft.studio.server.model.MRCSS;
import com.jaspersoft.studio.server.model.MRDataAdapter;
import com.jaspersoft.studio.server.model.MRFont;
import com.jaspersoft.studio.server.model.MRImage;
import com.jaspersoft.studio.server.model.MRJson;
import com.jaspersoft.studio.server.model.MRQuery;
import com.jaspersoft.studio.server.model.MRSecureFile;
import com.jaspersoft.studio.server.model.MRStyleTemplate;
import com.jaspersoft.studio.server.model.MReference;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.MResourceBundle;
import com.jaspersoft.studio.server.model.MXmlFile;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceAWS;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceBean;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceCustom;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceDiagnostic;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceJDBC;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceJNDI;
import com.jaspersoft.studio.server.model.datasource.MRDatasourceVDS;
import com.jaspersoft.studio.server.model.datasource.MRMondrianSchema;
import com.jaspersoft.studio.server.model.datasource.MROlapMondrianConnection;
import com.jaspersoft.studio.server.model.datasource.MROlapUnit;
import com.jaspersoft.studio.server.model.datasource.MROlapXmlaConnection;
import com.jaspersoft.studio.server.model.datasource.MRSecureMondrianConnection;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.Version;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import com.jaspersoft.studio.utils.Callback;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class AddResourcePage
extends JSSHelpWizardPage {
    private AMResource resource;
    private ANode parent;
    private boolean dsonly = false;
    private boolean ruOnly = false;
    private boolean monOnly = false;
    private boolean olapOnly = false;

    public AddResourcePage(ANode parent) {
        super("addresource");
        this.setTitle(Messages.AddResourcePage_Title);
        String title = ANode.getIconDescriptor().getTitle();
        if (parent instanceof MServerProfile) {
            title = MServerProfile.getIconDescriptor().getTitle();
        } else if (parent instanceof AMResource) {
            title = ((AMResource)parent).getThisIconDescriptor().getTitle();
        }
        this.setDescription(MessageFormat.format(Messages.AddResourcePage_Description, title, parent.getDisplayText()));
        this.parent = parent;
    }

    public AMResource getResource() {
        return this.resource;
    }

    public void createControl(Composite parent) {
        final TreeViewer treeViewer = new TreeViewer(parent, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        gd.widthHint = 400;
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
        treeViewer.setInput((Object)this.getInput());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection ts = (TreeSelection)event.getSelection();
                Object obj = ts.getFirstElement();
                AddResourcePage.this.resource = obj != null && obj instanceof AMResource ? (AMResource)((Object)obj) : null;
                AddResourcePage.this.setPageComplete(AddResourcePage.this.canFlipToNextPage());
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AddResourcePage.this.canFlipToNextPage()) {
                    AddResourcePage.this.getContainer().showPage(AddResourcePage.this.getNextPage());
                } else {
                    TreeSelection s = (TreeSelection)treeViewer.getSelection();
                    Object fe = s.getFirstElement();
                    if (treeViewer.getExpandedState(fe)) {
                        treeViewer.collapseToLevel(fe, 1);
                    } else {
                        treeViewer.expandToLevel(fe, 1);
                    }
                }
            }
        });
        this.setControl(treeViewer.getControl());
        treeViewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{this.resource})), true);
    }

    public void setOnlyDatasource(boolean dsonly) {
        this.dsonly = dsonly;
    }

    public void setOnlyReportUnit(boolean ruOnly) {
        this.ruOnly = ruOnly;
    }

    public void setMondrianOnly(boolean monOnly) {
        this.monOnly = monOnly;
    }

    public void setOlapOnly(boolean olapOnly) {
        this.olapOnly = olapOnly;
    }

    private ANode getInput() {
        MServerProfile root = new MServerProfile(null, null);
        if (this.parent instanceof AMResource) {
            root.setWsClient(((AMResource)this.parent).getWsClient());
        }
        if (this.parent instanceof MServerProfile) {
            root.setWsClient(((MServerProfile)this.parent).getWsClient((Callback<IConnection>)null));
        }
        if (this.dsonly) {
            this.createDatasources(root);
        } else if (this.ruOnly) {
            this.createReportUnit(root);
        } else if (this.monOnly) {
            this.createMondrian(root);
        } else if (this.olapOnly) {
            this.createOlap(root);
        } else {
            if (this.parent instanceof MFolder || this.parent instanceof MServerProfile) {
                new MFolder(root, MFolder.createDescriptor(this.parent), -1);
                this.createReportUnit(root);
                new MJrxml(root, MJrxml.createDescriptor(this.parent), -1);
                new MInputControl(root, MInputControl.createDescriptor(this.parent), -1);
                new MListOfValues(root, MListOfValues.createDescriptor(this.parent), -1);
                this.createDatasources(root);
                new MDataType(root, MDataType.createDescriptor(this.parent), -1);
                new MRQuery(root, MRQuery.createDescriptor(this.parent), -1);
                MRoot oroot = new MRoot(root, null){
                    public static final long serialVersionUID = 10200L;

                    public String getDisplayText() {
                        return Messages.AddResourcePage_0;
                    }

                    public String getToolTip() {
                        return Messages.AddResourcePage_1;
                    }

                    public ImageDescriptor getImagePath() {
                        return MROlapMondrianConnection.getIconDescriptor().getIcon16();
                    }

                    public INode getRoot() {
                        return AddResourcePage.this.parent.getRoot();
                    }
                };
                new MRMondrianSchema((ANode)oroot, MRMondrianSchema.createDescriptor(this.parent), -1);
                if (!this.isSoap(root)) {
                    new MROlapUnit((ANode)oroot, MROlapUnit.createDescriptor(this.parent), -1);
                }
                new MRAccessGrantSchema(root, MRAccessGrantSchema.createDescriptor(this.parent), -1);
            }
            new MJar(root, MJar.createDescriptor(this.parent), -1);
            new MResourceBundle(root, MResourceBundle.createDescriptor(this.parent), -1);
            new MRFont(root, MRFont.createDescriptor(this.parent), -1);
            new MRImage(root, MRImage.createDescriptor(this.parent), -1);
            new MRCSS(root, MRCSS.createDescriptor(this.parent), -1);
            new MRSecureFile(root, MRSecureFile.createDescriptor(this.parent), -1);
            new MRAzureCertificate(root, MRAzureCertificate.createDescriptor(this.parent), -1);
            new MContentResource(root, MContentResource.createDescriptor(this.parent), -1);
            new MRStyleTemplate(root, MRStyleTemplate.createDescriptor(this.parent), -1);
            new MXmlFile(root, MXmlFile.createDescriptor(this.parent), -1);
            new MRJson(root, MRJson.createDescriptor(this.parent), -1);
            new MRDataAdapter(root, MRDataAdapter.createDescriptor(this.parent), -1);
            if (this.parent instanceof MReportUnit) {
                new MJrxml(root, MJrxml.createDescriptor(this.parent), -1);
                new MInputControl(root, MInputControl.createDescriptor(this.parent), -1);
                new MReference(root, MReference.createDescriptor(this.parent), -1);
                boolean dsexists = false;
                for (INode n : this.parent.getChildren()) {
                    if (!(n instanceof AMResource) || !SelectorDatasource.isDatasource(((AMResource)n).getValue())) continue;
                    dsexists = true;
                    break;
                }
                if (!dsexists) {
                    this.createDatasources(root);
                }
            }
            Activator.getExtManager().createNewResource(root, this.parent);
        }
        new ModelVisitor<ANode>((INode)root){

            public boolean visit(INode n) {
                if (n instanceof AMResource) {
                    ((AMResource)n).setEditMode(true);
                }
                return true;
            }
        };
        this.setResource((INode)root);
        return root;
    }

    private void setResource(INode rt) {
        if (rt.getChildren() != null && !rt.getChildren().isEmpty()) {
            INode iNode = (INode)rt.getChildren().get(0);
            if (iNode instanceof AMResource) {
                this.resource = (AMResource)iNode;
            } else {
                this.setResource(iNode);
            }
        }
    }

    protected void createReportUnit(ANode root) {
        new MReportUnit(root, MReportUnit.createDescriptor(this.parent), -1);
    }

    protected void createMondrian(ANode root) {
        ServerInfo si = AddResourcePage.getServerInfo(root);
        if (si != null && Version.isPro(si)) {
            new MRSecureMondrianConnection(root, MRSecureMondrianConnection.createDescriptor(this.parent), -1);
        } else {
            new MROlapMondrianConnection(root, MROlapMondrianConnection.createDescriptor(this.parent), -1);
        }
    }

    public static ServerInfo getServerInfo(ANode n) {
        try {
            if (n instanceof MServerProfile) {
                return ((MServerProfile)n).getWsClient().getServerInfo((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (n instanceof AMResource) {
            return AddResourcePage.getServerInfo((ANode)n.getRoot());
        }
        return null;
    }

    private boolean isSoap(ANode n) {
        try {
            if (n instanceof MServerProfile) {
                return !((MServerProfile)n).getWsClient().isSupported(Feature.SEARCHREPOSITORY);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (n instanceof AMResource) {
            return this.isSoap((ANode)n.getRoot());
        }
        return true;
    }

    protected void createOlap(ANode root) {
        this.createMondrian(root);
        new MROlapXmlaConnection(root, MROlapXmlaConnection.createDescriptor(this.parent), -1);
    }

    protected MRoot createDatasources(ANode root) {
        MRoot mroot = new MRoot(root, null){
            public static final long serialVersionUID = 10200L;

            public String getDisplayText() {
                return Messages.AddResourcePage_2;
            }

            public String getToolTip() {
                return Messages.AddResourcePage_3;
            }

            public ImageDescriptor getImagePath() {
                return MRDatasourceJDBC.getIconDescriptor().getIcon16();
            }

            public INode getRoot() {
                return AddResourcePage.this.parent.getRoot();
            }
        };
        new MRDatasourceBean((ANode)mroot, MRDatasourceBean.createDescriptor(this.parent), -1);
        new MRDatasourceJDBC((ANode)mroot, MRDatasourceJDBC.createDescriptor(this.parent), -1);
        new MRDatasourceJNDI((ANode)mroot, MRDatasourceJNDI.createDescriptor(this.parent), -1);
        new MRDatasourceCustom((ANode)mroot, MRDatasourceCustom.createDescriptor(this.parent), -1);
        new MRDatasourceVDS((ANode)mroot, MRDatasourceVDS.createDescriptor(this.parent), -1);
        new MRDatasourceDiagnostic((ANode)mroot, MRDatasourceDiagnostic.createDescriptor(this.parent), -1);
        new MRDatasourceAWS((ANode)mroot, MRDatasourceAWS.createDescriptor(this.parent), -1);
        this.createOlap((ANode)mroot);
        Activator.getExtManager().createNewDatasource((ANode)mroot, this.parent);
        return mroot;
    }

    public boolean canFlipToNextPage() {
        return this.resource != null;
    }

    protected String getContextName() {
        return "com.jaspersoft.studio.doc.jasperserver_addnewresource_wizardpage";
    }
}

