/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.server.ResourceFactory;
import com.jaspersoft.studio.server.ServerManager;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.messages.Messages;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.model.MFolder;
import com.jaspersoft.studio.server.model.MReportUnit;
import com.jaspersoft.studio.server.model.server.MServerProfile;
import com.jaspersoft.studio.server.properties.dialog.RepositoryDialog;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.restv2.WsTypes;
import com.jaspersoft.studio.server.wizard.find.FindResourceJob;
import com.jaspersoft.studio.server.wizard.resource.APageContent;
import com.jaspersoft.studio.utils.UIUtil;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.ui.validator.EmptyStringValidator;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReferencePageContent
extends APageContent {
    private ResourceDescriptor ref;
    private Text trefuri;
    private Text tparent;
    private Text ttype;
    private Text tcdate;
    private Text tid;
    private Text tname;
    private Text tdesc;

    public ReferencePageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public ReferencePageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.reference";
    }

    @Override
    public String getName() {
        return Messages.RDReferencePage_textreference;
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        UIUtil.createLabel((Composite)composite, (String)(String.valueOf(Messages.RDReferencePage_referencedesc) + " "));
        this.trefuri = new Text(composite, 2056);
        this.trefuri.setLayoutData((Object)new GridData(772));
        this.trefuri.setEnabled(false);
        Button bbrowse = new Button(composite, 1028);
        bbrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MServerProfile msp = ServerManager.getMServerProfileCopy((MServerProfile)ReferencePageContent.this.pnode.getRoot());
                ResourceDescriptor resrd = ReferencePageContent.this.res.getValue();
                if (ReferencePageContent.this.res.isSupported(Feature.SEARCHREPOSITORY)) {
                    WsTypes.INST();
                    List<String> restTypes = WsTypes.getRestTypes();
                    ResourceDescriptor rd = FindResourceJob.doFindResource(msp, restTypes.toArray(new String[restTypes.size()]), new String[]{"folder", "reportUnit", "domainTopic"});
                    if (rd != null) {
                        resrd.setReferenceUri(rd.getUriString());
                        resrd.setIsReference(true);
                        resrd.setUriString(rd.getUriString());
                        resrd.setWsType(rd.getWsType());
                        ReferencePageContent.this.ref = rd;
                        ReferencePageContent.this.rebind();
                        ReferencePageContent.this.bindingContext.updateTargets();
                    }
                } else {
                    AMResource rs;
                    RepositoryDialog rd = new RepositoryDialog(UIUtils.getShell(), (INode)msp){

                        @Override
                        public boolean isResourceCompatible(AMResource r) {
                            return !(r instanceof MFolder) && !(r instanceof MReportUnit);
                        }
                    };
                    if (rd.open() == 0 && (rs = rd.getResource()) != null) {
                        resrd.setReferenceUri(rs.getValue().getUriString());
                        resrd.setUriString(rs.getValue().getUriString());
                        ReferencePageContent.this.loadReference(resrd);
                        ReferencePageContent.this.bindingContext.updateTargets();
                    }
                }
            }
        });
        Composite cmp = new Composite(composite, 0);
        cmp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        cmp.setLayoutData((Object)gd);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_parentfolder);
        this.tparent = new Text(cmp, 2056);
        this.tparent.setLayoutData((Object)new GridData(768));
        this.tparent.setEnabled(false);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_type);
        this.ttype = new Text(cmp, 2056);
        this.ttype.setLayoutData((Object)new GridData(768));
        this.ttype.setEnabled(false);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_creationdate);
        this.tcdate = new Text(cmp, 2056);
        this.tcdate.setLayoutData((Object)new GridData(768));
        this.tcdate.setEnabled(false);
        UIUtil.createSeparator((Composite)cmp, (int)2);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_refid);
        this.tid = new Text(cmp, 2056);
        this.tid.setLayoutData((Object)new GridData(768));
        this.tid.setEnabled(false);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_refname);
        this.tname = new Text(cmp, 2056);
        this.tname.setLayoutData((Object)new GridData(768));
        this.tname.setEnabled(false);
        UIUtil.createLabel((Composite)cmp, (String)Messages.RDReferencePage_refdesc);
        this.tdesc = new Text(cmp, 2122);
        gd = new GridData(1808);
        gd.minimumHeight = 100;
        this.tdesc.setLayoutData((Object)gd);
        this.tdesc.setEnabled(false);
        this.loadReference(this.res.getValue());
        this.rebind();
        return composite;
    }

    @Override
    protected void rebind() {
        Object[] bds;
        Object[] objectArray = bds = this.bindingContext.getBindings().toArray();
        int n = bds.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            Binding b = (Binding)obj;
            this.bindingContext.removeBinding(b);
            b.dispose();
            ++n2;
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.trefuri), PojoProperties.value((String)"referenceUri").observe((Object)this.res.getValue()));
        if (this.ref != null) {
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.tparent), PojoProperties.value((String)"parentFolder").observe((Object)this.ref));
            IConnection c = this.res.getWsClient();
            final Format f = c != null ? c.getTimestampFormat() : DateFormat.getTimeInstance();
            Converter t2mConv = new Converter(String.class, Date.class){

                public Object convert(Object fromObject) {
                    try {
                        if (fromObject != null && fromObject instanceof String && !((String)fromObject).isEmpty()) {
                            return f.parseObject((String)fromObject);
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            Converter m2tConv = new Converter(Date.class, String.class){

                public Object convert(Object fromObject) {
                    return f.format(fromObject);
                }
            };
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.tcdate), PojoProperties.value((String)"creationDate").observe((Object)this.ref), new UpdateValueStrategy().setConverter((IConverter)t2mConv), new UpdateValueStrategy().setConverter((IConverter)m2tConv));
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)0).observe((Widget)this.ttype), PojoProperties.value((String)"wsType").observe((Object)this.ref));
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tid), PojoProperties.value((String)"name").observe((Object)this.ref), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new EmptyStringValidator()), null);
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tname), PojoProperties.value((String)"label").observe((Object)this.ref), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new EmptyStringValidator()), null);
            this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tdesc), PojoProperties.value((String)"description").observe((Object)this.ref));
        }
        this.bindingContext.updateTargets();
    }

    @Override
    public boolean isPageComplete() {
        return super.isPageComplete() && this.ref != null;
    }

    private void loadReference(ResourceDescriptor resrd) {
        try {
            this.ref = WSClientHelper.getReference((IProgressMonitor)new NullProgressMonitor(), this.pnode, resrd);
            if (this.ref != null) {
                this.rebind();
                this.bindingContext.updateTargets();
                if (ResourceFactory.isFileResourceType(this.ref)) {
                    this.res.getValue().setWsType("reference");
                } else {
                    this.res.getValue().setWsType(this.ref.getWsType());
                }
                this.setPageComplete(this.isPageComplete());
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
    }
}

