/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.wizard.resource.page.datasource;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceProperty;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.server.model.AMResource;
import com.jaspersoft.studio.server.utils.ResourceDescriptorUtil;
import com.jaspersoft.studio.server.wizard.resource.page.datasource.DatasourceJDBCPageContent;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatasourceAWSPageContent
extends DatasourceJDBCPageContent {
    private Text awsAccessKey;
    private Text awsSecretKey;
    private Text awsArn;
    private Binding bAccessKey;
    private Binding bSecretKey;
    private Binding bArn;
    private Button ec2Cred;
    private Button awsCred;
    private Proxy p;
    private Text awsRegion;
    private Text awsService;
    private Text awsDBInstance;
    private Text awsDSDBName;

    public DatasourceAWSPageContent(ANode parent, AMResource resource, DataBindingContext bindingContext) {
        super(parent, resource, bindingContext);
    }

    public DatasourceAWSPageContent(ANode parent, AMResource resource) {
        super(parent, resource);
    }

    @Override
    public String getPageName() {
        return "com.jaspersoft.studio.server.page.datasource.aws";
    }

    @Override
    public Control createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.ec2Cred = new Button(composite, 16);
        this.ec2Cred.setText("Use EC2 instance credentials.");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.ec2Cred.setLayoutData((Object)gd);
        this.ec2Cred.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatasourceAWSPageContent.this.ec2Cred.getSelection()) {
                    ResourceDescriptor rd = DatasourceAWSPageContent.this.res.getValue();
                    rd.setResourceProperty("accessKey", null);
                    rd.setResourceProperty("secretKey", null);
                    rd.setResourceProperty("roleArn", null);
                    DatasourceAWSPageContent.this.unbindAWS();
                    DatasourceAWSPageContent.this.setEC2Settings(true);
                }
            }
        });
        this.awsCred = new Button(composite, 16);
        this.awsCred.setText("Use AWS Credentials (Click here to generate using CloudFormation, see Outputs for keys after stack completes).");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.awsCred.setLayoutData((Object)gd);
        this.awsCred.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatasourceAWSPageContent.this.awsCred.getSelection()) {
                    DatasourceAWSPageContent.this.bindAWS();
                    DatasourceAWSPageContent.this.setEC2Settings(false);
                }
            }
        });
        UIUtil.createLabel((Composite)composite, (String)"AWS Access Key");
        this.awsAccessKey = new Text(composite, 2048);
        this.awsAccessKey.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"AWS Secret Key");
        this.awsSecretKey = new Text(composite, 0x400800);
        this.awsSecretKey.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"ARN");
        this.awsArn = new Text(composite, 2048);
        this.awsArn.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"AWS Region");
        this.awsRegion = new Text(composite, 2048);
        this.awsRegion.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"AWS Datasource");
        this.awsService = new Text(composite, 2048);
        this.awsService.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"AWS Instance DB Identifier");
        this.awsDBInstance = new Text(composite, 2048);
        this.awsDBInstance.setLayoutData((Object)new GridData(768));
        UIUtil.createLabel((Composite)composite, (String)"Data Source DB Name");
        this.awsDSDBName = new Text(composite, 2048);
        this.awsDSDBName.setLayoutData((Object)new GridData(768));
        Control c = super.createContent(composite, false, false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        this.rebind();
        return composite;
    }

    @Override
    protected void rebind() {
        super.rebind();
        ResourceDescriptor rd = this.res.getValue();
        this.p = new Proxy(rd);
        List<ResourceProperty> props = rd.getProperties();
        boolean ec2 = ResourceDescriptorUtil.getProperty("accessKey", props) == null;
        this.setEC2Settings(ec2);
        if (!ec2) {
            this.bindAWS();
        }
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsRegion), PojoProperties.value((String)"datasourceAwsRegion").observe((Object)this.p));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsService), PojoProperties.value((String)"datasourceAwsDbService").observe((Object)this.p));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsDBInstance), PojoProperties.value((String)"datasourceAwsDbInstanceIdentifier").observe((Object)this.p));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsDSDBName), PojoProperties.value((String)"datasourceAwsDbName").observe((Object)this.p));
    }

    private void setEC2Settings(boolean ec2) {
        this.ec2Cred.setSelection(ec2);
        this.awsCred.setSelection(!ec2);
        this.awsAccessKey.setEnabled(!ec2);
        this.awsSecretKey.setEnabled(!ec2);
        this.awsArn.setEnabled(!ec2);
    }

    private void bindAWS() {
        this.bAccessKey = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsAccessKey), PojoProperties.value((String)"datasourceAwsAccessKey").observe((Object)this.p));
        this.bSecretKey = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsSecretKey), PojoProperties.value((String)"datasourceAwsSecretKey").observe((Object)this.p));
        this.bArn = this.bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.awsArn), PojoProperties.value((String)"datasourceAwsRoleArn").observe((Object)this.p));
    }

    private void unbindAWS() {
        if (this.bAccessKey != null) {
            this.bindingContext.removeBinding(this.bAccessKey);
        }
        if (this.bSecretKey != null) {
            this.bindingContext.removeBinding(this.bSecretKey);
        }
        if (this.bArn != null) {
            this.bindingContext.removeBinding(this.bArn);
        }
    }

    protected class Proxy {
        private ResourceDescriptor rd;

        public Proxy(ResourceDescriptor rd) {
            this.rd = rd;
        }

        public void setDatasourceAwsRegion(String v) {
            this.rd.setResourceProperty("region", v);
        }

        public String getDatasourceAwsRegion() {
            return this.rd.getResourcePropertyValue("region");
        }

        public void setDatasourceAwsDbService(String v) {
            this.rd.setResourceProperty("dbService", v);
        }

        public String getDatasourceAwsDbService() {
            return this.rd.getResourcePropertyValue("dbService");
        }

        public void setDatasourceAwsDbInstanceIdentifier(String v) {
            this.rd.setResourceProperty("dbInstanceIdentifier", v);
        }

        public String getDatasourceAwsDbInstanceIdentifier() {
            return this.rd.getResourcePropertyValue("dbInstanceIdentifier");
        }

        public void setDatasourceAwsDbName(String v) {
            this.rd.setResourceProperty("dbName", v);
        }

        public String getDatasourceAwsDbName() {
            return this.rd.getResourcePropertyValue("dbName");
        }

        public void setDatasourceAwsAccessKey(String v) {
            this.rd.setResourceProperty("accessKey", v);
        }

        public String getDatasourceAwsAccessKey() {
            return this.rd.getResourcePropertyValue("accessKey");
        }

        public void setDatasourceAwsSecretKey(String v) {
            this.rd.setResourceProperty("secretKey", v);
        }

        public String getDatasourceAwsSecretKey() {
            return this.rd.getResourcePropertyValue("secretKey");
        }

        public void setDatasourceAwsRoleArn(String v) {
            this.rd.setResourceProperty("roleArn", v);
        }

        public String getDatasourceAwsRoleArn() {
            return this.rd.getResourcePropertyValue("roleArn");
        }
    }
}

