/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.TabbedPropertyComposite;
import com.jaspersoft.studio.properties.view.ITabItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TabbedPropertyList {
    protected static final int NONE = -1;
    private int selectedElementIndex = -1;
    private ToolBarManager toolBarManager;
    private CoolItem coolItem;
    private CoolBar cBar;
    private Menu chevronMenu;

    public TabbedPropertyList(Composite parent) {
        this.cBar = new CoolBar(parent, 256);
        this.cBar.setLocked(true);
        this.coolItem = new CoolItem(this.cBar, 524292);
        final ToolBar toolBar = new ToolBar((Composite)this.cBar, 0x8A0000);
        this.toolBarManager = new ToolBarManager(toolBar);
        this.coolItem.setControl((Control)toolBar);
        this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    CoolItem item = (CoolItem)event.widget;
                    Rectangle itemBounds = item.getBounds();
                    Point pt = TabbedPropertyList.this.cBar.toDisplay(new Point(itemBounds.x, itemBounds.y));
                    itemBounds.x = pt.x;
                    itemBounds.y = pt.y;
                    ToolBar bar = (ToolBar)item.getControl();
                    ToolItem[] tools = bar.getItems();
                    int i = 0;
                    int toolsWidth = TabbedPropertyList.this.cBar.getBounds().width - toolBar.getBounds().width;
                    while (i < tools.length) {
                        Rectangle toolBounds = tools[i].getBounds();
                        if ((toolsWidth += toolBounds.width) > itemBounds.width) break;
                        ++i;
                    }
                    if (TabbedPropertyList.this.chevronMenu != null) {
                        TabbedPropertyList.this.chevronMenu.dispose();
                    }
                    TabbedPropertyList.this.chevronMenu = new Menu((Control)TabbedPropertyList.this.cBar);
                    int j = i;
                    while (j < tools.length) {
                        final ToolItem titem = tools[j];
                        MenuItem menuItem = new MenuItem(TabbedPropertyList.this.chevronMenu, 8);
                        menuItem.setText(titem.getText());
                        menuItem.setImage(titem.getImage());
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (titem.getData() instanceof ActionContributionItem) {
                                    ((ActionContributionItem)titem.getData()).getAction().run();
                                }
                            }
                        });
                        ++j;
                    }
                    pt = TabbedPropertyList.this.cBar.toDisplay(new Point(event.x, event.y));
                    TabbedPropertyList.this.chevronMenu.setLocation(pt.x, pt.y);
                    TabbedPropertyList.this.chevronMenu.setVisible(true);
                }
            }
        });
        this.calcSize(this.coolItem);
    }

    public Composite getControl() {
        return this.cBar;
    }

    private void calcSize(CoolItem item) {
        this.cBar.pack();
        this.toolBarManager.update(true);
    }

    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    public void removeAll() {
        this.toolBarManager.removeAll();
        this.toolBarManager.update(true);
        this.selectedElementIndex = -1;
    }

    public void setElements(Object[] children) {
        this.removeAll();
        int i = 0;
        while (i < children.length) {
            ITabItem tabItem = (ITabItem)children[i];
            ActionContributionItem aci = new ActionContributionItem((IAction)new TabAction(tabItem));
            aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            this.toolBarManager.add((IContributionItem)aci);
            ++i;
        }
        this.calcSize(this.coolItem);
    }

    protected void select(int index) {
        if (this.getSelectionIndex() == index) {
            IContributionItem item = this.toolBarManager.getItems()[index];
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aItem = (ActionContributionItem)item;
                aItem.getAction().setChecked(true);
            }
            return;
        }
        this.deselectAll();
        IContributionItem[] items = this.toolBarManager.getItems();
        if (index >= 0 && index < items.length) {
            ((ActionContributionItem)items[index]).getAction().setChecked(true);
            this.selectedElementIndex = index;
            this.cBar.notifyListeners(13, new Event());
        }
    }

    public void deselectAll() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.toolBarManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem i = iContributionItemArray[n2];
            ((ActionContributionItem)i).getAction().setChecked(false);
            ++n2;
        }
        this.selectedElementIndex = -1;
    }

    class TabAction
    extends Action {
        public TabAction(ITabItem tabItem) {
            super(tabItem.getText(), 2);
            this.setImageDescriptor(tabItem.getImage());
        }

        public void run() {
            IContributionItem[] items = TabbedPropertyList.this.toolBarManager.getItems();
            int i = 0;
            while (i < items.length) {
                ActionContributionItem item = (ActionContributionItem)items[i];
                if (item.getAction() == this) {
                    TabbedPropertyList.this.select(i);
                    Composite tabbedPropertyComposite = TabbedPropertyList.this.cBar.getParent();
                    while (!(tabbedPropertyComposite instanceof TabbedPropertyComposite)) {
                        tabbedPropertyComposite = tabbedPropertyComposite.getParent();
                    }
                    tabbedPropertyComposite.setFocus();
                }
                ++i;
            }
        }
    }
}

