/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.internal;

import com.jaspersoft.studio.properties.internal.InputType;
import com.jaspersoft.studio.properties.view.ISectionDescriptor;
import com.jaspersoft.studio.properties.view.ITypeMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TabbedPropertyRegistryClassSectionFilter {
    private ITypeMapper typeMapper = null;

    public TabbedPropertyRegistryClassSectionFilter(ITypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    public boolean appliesToSelection(ISectionDescriptor descriptor, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (descriptor.getEnablesFor() != -1 && ((IStructuredSelection)selection).size() != descriptor.getEnablesFor()) {
                return false;
            }
            IFilter filter = descriptor.getFilter();
            if (filter != null) {
                for (Object object : (IStructuredSelection)selection) {
                    if (filter == null || filter.select(object)) continue;
                    return false;
                }
                return true;
            }
            HashSet effectiveTypes = new HashSet();
            for (Object object : (IStructuredSelection)selection) {
                Class<?> remapType = object.getClass();
                if (this.typeMapper != null) {
                    remapType = this.typeMapper.mapType(object);
                }
                if (!effectiveTypes.add(remapType) || this.appliesToEffectiveType(descriptor, remapType)) continue;
                return false;
            }
        } else if (descriptor.getFilter() != null) {
            return descriptor.getFilter().select((Object)selection);
        }
        return true;
    }

    private boolean appliesToEffectiveType(ISectionDescriptor descriptor, Class<?> inputClass) {
        List<String> classTypes = null;
        List<InputType> sectionInputTypes = descriptor.getInputTypes();
        for (InputType type : sectionInputTypes) {
            if (type.isExcludeSubtype()) {
                if (!inputClass.getName().equals(type.getType())) continue;
                return true;
            }
            if (classTypes == null) {
                classTypes = this.getClassTypes(inputClass);
            }
            if (!classTypes.contains(type.getType())) continue;
            return true;
        }
        return false;
    }

    protected List<String> getClassTypes(Class<?> target) {
        ArrayList<String> result = new ArrayList<String>();
        List<Class<?>> classes = this.computeClassOrder(target);
        for (Class<?> i : classes) {
            result.add(i.getName());
        }
        result.addAll(this.computeInterfaceOrder(classes));
        return result;
    }

    private List<Class<?>> computeClassOrder(Class<?> target) {
        ArrayList result = new ArrayList(4);
        Class<?> clazz = target;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List<String> computeInterfaceOrder(List<Class<?>> classes) {
        ArrayList<String> result = new ArrayList<String>(4);
        HashMap seen = new HashMap(4);
        for (Class<?> iter : classes) {
            Class<?>[] interfaces = iter.getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void internalComputeInterfaceOrder(Class<?>[] interfaces, List<String> result, Map<Class<?>, Class<?>> seen) {
        void var5_6;
        ArrayList newInterfaces = new ArrayList(seen.size());
        boolean bl = false;
        while (var5_6 < interfaces.length) {
            Class<?> interfac = interfaces[var5_6];
            if (seen.get(interfac) == null) {
                result.add(interfac.getName());
                seen.put(interfac, interfac);
                newInterfaces.add(interfac);
            }
            ++var5_6;
        }
        for (Class clazz : newInterfaces) {
            this.internalComputeInterfaceOrder(clazz.getInterfaces(), result, seen);
        }
    }
}

