/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ResizableControlLayout
extends Layout {
    private int defaultControlWidth;

    public ResizableControlLayout(int defaultControlWidth) {
        this.defaultControlWidth = defaultControlWidth;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control label = composite.getChildren()[0];
        Control control = composite.getChildren()[1];
        Point sizeLabel = label.computeSize(-1, -1);
        Point sizeControl = control.computeSize(-1, -1);
        int width = this.defaultControlWidth + sizeLabel.x + 8;
        if (clientArea.width != 0 && sizeControl.x > this.defaultControlWidth) {
            width = Math.min(clientArea.width, sizeControl.x) + sizeLabel.x + 8;
        }
        return new Point(width, Math.max(sizeLabel.y, sizeControl.y));
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control label = composite.getChildren()[0];
        Point labelSize = label.computeSize(-1, -1);
        label.setSize(labelSize.x, labelSize.y);
        label.setBounds(0, 0, labelSize.x, labelSize.y);
        int startX = labelSize.x + 8;
        Control control = composite.getChildren()[1];
        Point size = control.computeSize(-1, -1);
        if (composite.getClientArea().width != 0 && size.x > composite.getClientArea().width - startX) {
            control.setBounds(startX, 0, composite.getClientArea().width - startX, size.y);
        } else {
            control.setBounds(startX, 0, size.x, size.y);
        }
    }
}

