/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.properties.view;

import com.jaspersoft.studio.properties.internal.TabbedPropertyComposite;
import com.jaspersoft.studio.properties.internal.TabbedPropertyRegistry;
import com.jaspersoft.studio.properties.internal.TabbedPropertyRegistryFactory;
import com.jaspersoft.studio.properties.internal.TabbedPropertyTitle;
import com.jaspersoft.studio.properties.internal.TabbedPropertyViewer;
import com.jaspersoft.studio.properties.view.AbstractPropertySection;
import com.jaspersoft.studio.properties.view.ErrorsDialog;
import com.jaspersoft.studio.properties.view.IActionProvider;
import com.jaspersoft.studio.properties.view.ISection;
import com.jaspersoft.studio.properties.view.ITabDescriptor;
import com.jaspersoft.studio.properties.view.ITabbedPropertySheetPageContributor;
import com.jaspersoft.studio.properties.view.TabContents;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetWidgetFactory;
import com.jaspersoft.studio.properties.view.validation.IValidable;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class TabbedPropertySheetPage
extends Page
implements IPropertySheetPage {
    private static PagesWatcher WATCHER = new PagesWatcher();
    private Long PAGE_EXPIRATION_TIME = 36000000L;
    private TabbedPropertyComposite tabbedPropertyComposite;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private ITabbedPropertySheetPageContributor contributor;
    private TabbedPropertyRegistry registry;
    private String currentContributorId;
    protected IStructuredContentProvider tabListContentProvider;
    private ISelection currentSelection;
    private TabbedPropertyViewer tabbedPropertyViewer;
    private TabContents currentTab;
    private Map<ITabDescriptor, TabContents> descriptorToTab;
    private Map<TabContents, Pair<Composite, Long>> tabToComposite;
    private Map<Object, String> lastSelectedTabForElement;
    private boolean hasTitleBar;
    private ControlDecoration cd;
    private List<ValidationError> errors;

    public void showErrors() {
        IStructuredSelection selection = (IStructuredSelection)this.tabbedPropertyViewer.getSelection();
        TabContents tab = null;
        ITabDescriptor descriptor = (ITabDescriptor)selection.getFirstElement();
        if (descriptor != null) {
            Object obj;
            tab = this.getTab(descriptor);
            if (this.tabbedPropertyViewer != null && this.tabbedPropertyViewer.getInput() != null && (obj = this.tabbedPropertyViewer.getInput()) instanceof StructuredSelection && ((StructuredSelection)obj).size() == 1) {
                Object m = ((StructuredSelection)obj).getFirstElement();
                if (m instanceof EditPart) {
                    m = ((EditPart)m).getModel();
                }
                if (m instanceof IValidable) {
                    this.errors = ((IValidable)m).validate();
                    if (this.errors != null && !this.errors.isEmpty()) {
                        this.getErrorControlDecorator();
                        String error = "";
                        String del = "";
                        this.cd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_WARNING"));
                        for (ValidationError ve : this.errors) {
                            error = String.valueOf(error) + del + ve.getMessage();
                            del = "\n";
                            if (ve.isWarning()) continue;
                            this.cd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"));
                        }
                        this.cd.setDescriptionText(error);
                        this.cd.show();
                        ISection[] iSectionArray = tab.getSections();
                        int n = iSectionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ISection sec = iSectionArray[n2];
                            if (sec instanceof AbstractPropertySection) {
                                ((AbstractPropertySection)sec).showErrors(this.errors);
                            }
                            ++n2;
                        }
                        return;
                    }
                    this.resetErrors(tab);
                }
            }
        }
    }

    protected ControlDecoration getErrorControlDecorator() {
        if (this.cd == null) {
            final TabbedPropertyTitle title = this.tabbedPropertyComposite.getTitle();
            this.cd = new ControlDecoration((Control)title.getLabel(), 17408);
            this.cd.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR"));
            this.cd.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private ErrorsDialog ed;

                public void widgetSelected(SelectionEvent e) {
                    TabbedPropertySheetPage.this.cd.hideHover();
                    if (this.ed != null) {
                        this.ed.close();
                        return;
                    }
                    TabbedPropertySheetPage.this.cd.setShowHover(false);
                    this.ed = new ErrorsDialog(){

                        @Override
                        protected void close() {
                            super.close();
                            (this).TabbedPropertySheetPage.this.cd.setShowHover(true);
                            ed = null;
                        }
                    };
                    Rectangle r = Display.getDefault().map((Control)title.getLabel(), null, 0, 0, 0, 0);
                    this.ed.createDialog(TabbedPropertySheetPage.this, new Point(r.x + 4, r.y + 6), TabbedPropertySheetPage.this.errors);
                }
            });
        }
        return this.cd;
    }

    public void resetErrors(TabContents tab) {
        this.errors = null;
        this.cd = this.getErrorControlDecorator();
        this.cd.hide();
        ISection[] iSectionArray = tab.getSections();
        int n = iSectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISection s = iSectionArray[n2];
            if (s instanceof AbstractPropertySection) {
                ((AbstractPropertySection)s).resetErrors();
            }
            ++n2;
        }
    }

    public TabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, boolean showTitleBar) {
        this.hasTitleBar = showTitleBar;
        this.contributor = tabbedPropertySheetPageContributor;
        this.currentContributorId = this.contributor.getContributorId();
        this.tabToComposite = new HashMap<TabContents, Pair<Composite, Long>>();
        this.descriptorToTab = new HashMap<ITabDescriptor, TabContents>();
        this.lastSelectedTabForElement = new HashMap<Object, String>();
        this.validateRegistry();
        WATCHER.addPage(this);
    }

    private TabContents getTab(ITabDescriptor descriptor) {
        TabContents tab = this.descriptorToTab.get(descriptor);
        if (tab == null) {
            tab = descriptor.createTab();
            this.descriptorToTab.put(descriptor, tab);
        }
        return tab;
    }

    private ITabDescriptor getTabDescriptor(TabContents tab) {
        for (Map.Entry<ITabDescriptor, TabContents> tabEntry : this.descriptorToTab.entrySet()) {
            if (tabEntry.getValue() != tab) continue;
            return tabEntry.getKey();
        }
        return null;
    }

    public void setSelection(TabContents tab) {
        this.tabbedPropertyViewer.setSelectionToWidget(this.getTabDescriptor(tab).getId(), 0);
    }

    public void updatePageMinimumSize() {
        if (this.currentTab != null) {
            this.tabbedPropertyComposite.updatePageMinimumSize();
        }
    }

    public void createControl(Composite parent) {
        this.widgetFactory = new TabbedPropertySheetWidgetFactory(this);
        this.tabbedPropertyComposite = new TabbedPropertyComposite(parent, this, this.hasTitleBar);
        this.tabbedPropertyComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TabbedPropertySheetPage.this.updatePageMinimumSize();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tabbedPropertyComposite, "com.jaspersoft.studio.doc.view_properties");
        this.tabbedPropertyComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.tabbedPropertyComposite.setLayoutData(formData);
        this.tabbedPropertyViewer = new TabbedPropertyViewer(this.tabbedPropertyComposite.getList());
        this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        this.tabbedPropertyViewer.addSelectionChangedListener(new SelectionChangedListener());
        if (this.hasTitleBar && this.registry == null && this.currentContributorId != null) {
            this.initContributor(this.currentContributorId);
        }
    }

    public TabbedPropertyComposite getTabbedPropertyComposite() {
        return this.tabbedPropertyComposite;
    }

    private void initContributor(String contributorId) {
        this.registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(this.contributor);
        this.tabListContentProvider = this.getTabListContentProvider();
        boolean bl = this.hasTitleBar = this.hasTitleBar && this.registry.getLabelProvider() != null;
        if (this.tabbedPropertyViewer != null) {
            this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        }
    }

    protected IStructuredContentProvider getTabListContentProvider() {
        return this.registry.getTabListContentProvider();
    }

    public void dispose() {
        WATCHER.removePage(this);
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
            this.widgetFactory = null;
        }
        if (this.registry != null) {
            TabbedPropertyRegistryFactory.getInstance().disposeRegistry(this.contributor);
            this.registry = null;
        }
        this.contributor = null;
        this.currentContributorId = null;
        this.currentSelection = null;
        this.disposeTabs();
    }

    private void disposeTabs() {
        for (Map.Entry<TabContents, Pair<Composite, Long>> pair : this.tabToComposite.entrySet()) {
            Composite composite = (Composite)pair.getValue().getKey();
            pair.getKey().dispose();
            if (composite == null) continue;
            composite.dispose();
        }
        this.tabToComposite.clear();
        this.descriptorToTab.clear();
    }

    public Control getControl() {
        return this.tabbedPropertyComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        IActionBars partActionBars = null;
        if (this.contributor instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)this.contributor;
            partActionBars = editorPart.getEditorSite().getActionBars();
        } else if (this.contributor instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)this.contributor;
            partActionBars = viewPart.getViewSite().getActionBars();
        }
        if (partActionBars != null) {
            IAction action = partActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
            if (action != null) {
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            }
            if ((action = partActionBars.getGlobalActionHandler(ActionFactory.REDO.getId())) != null) {
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            }
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            selection = new StructuredSelection();
        }
        this.setInput(part, selection);
    }

    private void storeCurrentTabSelection(ITabDescriptor tab) {
        this.lastSelectedTabForElement.put(this.getSelectedObject(), tab.getId());
    }

    public Object getSelectedObject() {
        if (this.currentSelection instanceof IStructuredSelection) {
            return ((IStructuredSelection)this.currentSelection).getFirstElement();
        }
        return null;
    }

    private Composite createTabComposite(ITabDescriptor tab) {
        return this.tabbedPropertyComposite.createTabContents(tab);
    }

    private void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.tabbedPropertyViewer.setInput(part, this.currentSelection);
        String selectedTabIndex = this.lastSelectedTabForElement.get(this.getSelectedObject());
        if (this.tabbedPropertyViewer.getElements().size() > 0) {
            this.tabbedPropertyComposite.showEmptyPage(false);
            int defaultValue = 0;
            if (selectedTabIndex == null) {
                defaultValue = this.contributor.getDefaultSelectedPageIndex();
            }
            this.tabbedPropertyViewer.setSelectionToWidget(selectedTabIndex, defaultValue);
            this.refreshTitleBar();
        } else {
            this.tabbedPropertyComposite.showEmptyPage(true);
        }
    }

    public TabContents getCurrentTab() {
        return this.currentTab;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void refreshTitleBar() {
        if (this.hasTitleBar && this.registry != null) {
            TabbedPropertyTitle title = this.tabbedPropertyComposite.getTitle();
            if (this.currentTab == null) {
                title.setTitle(null, null);
            } else {
                String text = this.registry.getLabelProvider().getText((Object)this.currentSelection);
                Image image = this.registry.getLabelProvider().getImage((Object)this.currentSelection);
                title.setTitle(text, image);
            }
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.refreshTitleBar();
    }

    private void validateRegistry() {
        this.initContributor(this.currentContributorId);
        this.overrideActionBars();
    }

    private void overrideActionBars() {
        if (this.registry.getActionProvider() != null) {
            IActionProvider actionProvider = this.registry.getActionProvider();
            actionProvider.setActionBars(this.contributor, this.getSite().getActionBars());
        }
    }

    public List<TabContents> getCurrentTabs() {
        ArrayList<TabContents> result = new ArrayList<TabContents>();
        for (ITabDescriptor desc : this.tabbedPropertyViewer.getElements()) {
            result.add(this.getTab(desc));
        }
        return result;
    }

    private boolean isTabVisible(ITabDescriptor descriptor) {
        return this.tabbedPropertyComposite.getTabState(descriptor) == TabbedPropertyComposite.TabState.TAB_ALREADY_VISIBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExpiredTabs() {
        TabbedPropertySheetPage tabbedPropertySheetPage = this;
        synchronized (tabbedPropertySheetPage) {
            long currentTime = System.currentTimeMillis();
            HashMap<TabContents, Pair<Composite, Long>> mapCopy = new HashMap<TabContents, Pair<Composite, Long>>(this.tabToComposite);
            for (Map.Entry entry : mapCopy.entrySet()) {
                ITabDescriptor descriptor;
                Pair entryValues = (Pair)entry.getValue();
                Long lastTimeUsed = (Long)entryValues.getValue();
                if (lastTimeUsed == -1L || currentTime - lastTimeUsed <= this.PAGE_EXPIRATION_TIME || (descriptor = this.getTabDescriptor((TabContents)entry.getKey())) == null || this.isTabVisible(descriptor)) continue;
                this.tabbedPropertyComposite.destroyTabContents(descriptor);
                this.tabToComposite.remove(entry.getKey());
            }
        }
    }

    private static class PagesWatcher {
        private List<TabbedPropertySheetPage> pages = new ArrayList<TabbedPropertySheetPage>();

        private PagesWatcher() {
        }

        public void processPages() {
            for (TabbedPropertySheetPage page : new ArrayList<TabbedPropertySheetPage>(this.pages)) {
                if (page.tabbedPropertyComposite.isDisposed()) {
                    this.pages.remove((Object)page);
                    continue;
                }
                page.removeExpiredTabs();
            }
        }

        public void addPage(TabbedPropertySheetPage page) {
            if (page != null) {
                this.pages.add(page);
            }
        }

        public void removePage(TabbedPropertySheetPage page) {
            if (page != null) {
                this.pages.remove((Object)page);
            }
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionChangedEvent event) {
            TabbedPropertySheetPage tabbedPropertySheetPage = TabbedPropertySheetPage.this;
            synchronized (tabbedPropertySheetPage) {
                if (!TabbedPropertySheetPage.this.tabbedPropertyComposite.isDisposed()) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    TabContents tab = null;
                    ITabDescriptor descriptor = (ITabDescriptor)selection.getFirstElement();
                    if (TabbedPropertySheetPage.this.currentTab != null) {
                        TabbedPropertySheetPage.this.currentTab.aboutToBeHidden();
                    }
                    if (descriptor != null) {
                        tab = TabbedPropertySheetPage.this.getTab(descriptor);
                        if (TabbedPropertySheetPage.this.tabbedPropertyViewer != null && TabbedPropertySheetPage.this.tabbedPropertyViewer.getInput() != null) {
                            Pair<Composite, Long> showedComposite;
                            tab.setInput(TabbedPropertySheetPage.this.tabbedPropertyViewer.getWorkbenchPart(), (ISelection)TabbedPropertySheetPage.this.tabbedPropertyViewer.getInput());
                            TabbedPropertyComposite.TabState state = TabbedPropertySheetPage.this.tabbedPropertyComposite.showTabContents(descriptor, tab);
                            if (state == TabbedPropertyComposite.TabState.TAB_NOT_DEFINED) {
                                Composite tabComposite = TabbedPropertySheetPage.this.createTabComposite(descriptor);
                                TabbedPropertySheetPage.this.tabToComposite.put(tab, (Pair<Composite, Long>)new Pair((Object)tabComposite, (Object)-1L));
                                tab.createControls(tabComposite, TabbedPropertySheetPage.this);
                                TabbedPropertySheetPage.this.tabbedPropertyComposite.showTabContents(descriptor, tab);
                            }
                            if ((showedComposite = TabbedPropertySheetPage.this.tabToComposite.get(tab)) != null) {
                                showedComposite.setValue((Object)System.currentTimeMillis());
                            }
                            WATCHER.processPages();
                            TabbedPropertySheetPage.this.storeCurrentTabSelection(descriptor);
                            tab.refresh();
                            TabbedPropertySheetPage.this.currentTab = tab;
                            TabbedPropertySheetPage.this.currentTab.aboutToBeShown();
                            if (state != TabbedPropertyComposite.TabState.TAB_ALREADY_VISIBLE || state == TabbedPropertyComposite.TabState.TAB_DYNAMIC_VISIBLE) {
                                TabbedPropertySheetPage.this.tabbedPropertyComposite.layout();
                                TabbedPropertySheetPage.this.tabbedPropertyComposite.updatePageMinimumSize();
                            }
                            TabbedPropertySheetPage.this.showErrors();
                        }
                    }
                }
            }
        }
    }
}

