/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class SVNExternal {
    private File file;
    private String propertyLine;
    private String folder;
    private String path;
    private String url;
    private long revision = -1L;
    private long fixedAtRevision = -1L;
    private boolean selected;
    private static final String REGEXP_REVISION = "-r ?(\\d+)";
    private static final Pattern pattern = Pattern.compile("-r ?(\\d+)");

    public SVNExternal(File file, String propertyLine) {
        this.file = file;
        this.propertyLine = propertyLine;
        if (propertyLine != null) {
            ISVNLocalResource svnResource;
            int index;
            block20: {
                Matcher matcher = pattern.matcher(propertyLine);
                if (matcher.find()) {
                    String revision = matcher.group();
                    this.fixedAtRevision = revision.startsWith("-r ") ? Long.parseLong(revision.substring(3)) : Long.parseLong(revision.substring(2));
                    if (matcher.start() == 0) {
                        String urlAndFolder = propertyLine.substring(matcher.end() + 1);
                        int index2 = urlAndFolder.lastIndexOf(" ");
                        if (index2 != -1) {
                            this.url = urlAndFolder.substring(0, index2);
                            this.folder = urlAndFolder.substring(index2 + 1);
                            if (file != null) {
                                this.path = String.valueOf(file.getAbsolutePath()) + File.separator + urlAndFolder.substring(index2 + 1);
                            }
                        }
                    } else {
                        this.url = propertyLine.substring(matcher.end() + 1);
                        this.folder = propertyLine.substring(0, matcher.start() - 1);
                        if (file != null) {
                            this.path = String.valueOf(file.getAbsolutePath()) + File.separator + propertyLine.substring(0, matcher.start() - 1);
                        }
                    }
                } else {
                    int index3 = propertyLine.indexOf(" ");
                    if (index3 != -1) {
                        try {
                            new URL(propertyLine.substring(0, index3));
                            int lastIndex = propertyLine.lastIndexOf(" ");
                            if (lastIndex != -1) {
                                this.url = propertyLine.substring(0, lastIndex);
                                this.folder = propertyLine.substring(lastIndex + 1);
                                if (file != null) {
                                    this.path = String.valueOf(file.getAbsolutePath()) + File.separator + propertyLine.substring(lastIndex + 1);
                                }
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.url = propertyLine.substring(index3 + 1);
                            this.folder = propertyLine.substring(0, index3);
                            if (file == null) break block20;
                            this.path = String.valueOf(file.getAbsolutePath()) + File.separator + propertyLine.substring(0, index3);
                        }
                    }
                }
            }
            if (this.fixedAtRevision == -1L && this.url != null && (index = this.url.lastIndexOf("@")) != -1) {
                try {
                    this.fixedAtRevision = Long.parseLong(this.url.substring(index + 1));
                    this.url = this.url.substring(0, index);
                }
                catch (Exception exception) {}
            }
            if (this.path != null && (svnResource = SVNExternal.getSvnResource(this.path)) != null) {
                try {
                    this.revision = svnResource.getStatus().getLastChangedRevision().getNumber();
                }
                catch (SVNException sVNException) {}
            }
            if (this.revision == -1L && this.fixedAtRevision != -1L) {
                this.revision = this.fixedAtRevision;
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getPropertyLine() {
        return this.propertyLine;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getFixedAtRevision() {
        return this.fixedAtRevision;
    }

    public String toString() {
        if (!this.selected || this.revision == -1L) {
            return this.propertyLine;
        }
        return "-r" + this.revision + " " + this.url + "@" + (this.fixedAtRevision == -1L ? this.revision : this.fixedAtRevision) + " " + this.folder;
    }

    private static ISVNLocalResource getSvnResource(String path) {
        File file;
        Object resource = null;
        ISVNLocalResource svnResource = null;
        if (path != null && (file = new File(path)).exists() && (resource = file.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(path)) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path))) != null) {
            svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        }
        return svnResource;
    }
}

