/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class GetAnnotationsCommand
implements ISVNCommand {
    private ISVNAnnotations annotations;
    private final SVNRevision fromRevision;
    private final SVNRevision toRevision;
    private final ISVNRemoteFile remoteFile;
    private final boolean includeMergedRevisions;
    private final boolean ignoreMimeType;

    public GetAnnotationsCommand(ISVNRemoteFile remoteFile, SVNRevision fromRevision, SVNRevision toRevision, boolean includeMergedRevisions, boolean ignoreMimeType) {
        this.remoteFile = remoteFile;
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.includeMergedRevisions = includeMergedRevisions;
        this.ignoreMimeType = ignoreMimeType;
    }

    @Override
    public void run(IProgressMonitor aMonitor) throws SVNException {
        IProgressMonitor monitor = Policy.monitorFor(aMonitor);
        monitor.beginTask(Policy.bind("RemoteFile.getAnnotations"), 100);
        try {
            try {
                this.annotations = this.remoteFile.getAnnotations(this.fromRevision, this.toRevision, this.includeMergedRevisions, this.ignoreMimeType);
                monitor.worked(100);
            }
            catch (TeamException e) {
                throw SVNException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public ISVNAnnotations getAnnotations() {
        return this.annotations;
    }
}

