/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class LockResourcesCommand
implements ISVNCommand {
    private IResource[] resources;
    private String message;
    private boolean force;
    private SVNWorkspaceRoot root;
    private boolean refreshLocal;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public LockResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, boolean force, String message, boolean refreshLocal) {
        this.resources = resources;
        this.message = message;
        this.force = force;
        this.root = root;
        this.refreshLocal = refreshLocal;
    }

    public LockResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, boolean force, String message) {
        this(root, resources, force, message, true);
    }

    @Override
    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        File[] resourceFiles = new File[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            resourceFiles[i] = this.resources[i].getLocation().toFile();
            ++i;
        }
        try {
            try {
                monitor.beginTask(null, 100);
                svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.lock(resourceFiles, this.message, this.force);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            Set<IResource> operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources, this.refreshLocal);
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                this.root.getRepository().returnSVNClient(svnClient);
            }
            monitor.done();
        }
    }
}

