/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.osgi.service.prefs.Preferences;
import org.tigris.subversion.subclipse.core.mapping.SubclipseSubscriberResourceCollector;

public class SubclipseSubscriberChangeSetManager
extends ActiveChangeSetManager {
    private static final String PREF_CHANGE_SETS = "changeSets";
    private static final int RESOURCE_REMOVAL = 1;
    private static final int RESOURCE_CHANGE = 2;
    private EventHandler handler;
    private ResourceCollector collector;

    public SubclipseSubscriberChangeSetManager(Subscriber subscriber) {
        this.collector = new ResourceCollector(subscriber);
        this.handler = new EventHandler(NLS.bind((String)Messages.SubscriberChangeSetCollector_1, (Object[])new String[]{subscriber.getName()}), NLS.bind((String)Messages.SubscriberChangeSetCollector_2, (Object[])new String[]{subscriber.getName()}));
    }

    protected void initializeSets() {
        this.load(this.getPreferences());
    }

    public boolean hasMembers(IResource resource) {
        ChangeSet[] sets = this.getSets();
        int i = 0;
        while (i < sets.length) {
            ActiveChangeSet set = (ActiveChangeSet)sets[i];
            if (set.getDiffTree().getChildren(resource.getFullPath()).length > 0) {
                return true;
            }
            ++i;
        }
        if (this.getDefaultSet() != null) {
            return this.getDefaultSet().getDiffTree().getChildren(resource.getFullPath()).length > 0;
        }
        return false;
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        Subscriber subscriber = this.getSubscriber();
        return subscriber.getDiff(resource);
    }

    public Subscriber getSubscriber() {
        return this.collector.getSubscriber();
    }

    public void dispose() {
        this.handler.shutdown();
        this.collector.dispose();
        super.dispose();
        this.save(this.getPreferences());
    }

    private Preferences getPreferences() {
        return SubclipseSubscriberChangeSetManager.getParentPreferences().node(this.getSubscriberIdentifier());
    }

    private static Preferences getParentPreferences() {
        return SubclipseSubscriberChangeSetManager.getTeamPreferences().node(PREF_CHANGE_SETS);
    }

    private static Preferences getTeamPreferences() {
        return new InstanceScope().getNode(TeamPlugin.getPlugin().getBundle().getSymbolicName());
    }

    protected String getSubscriberIdentifier() {
        return this.getSubscriber().getName();
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.handler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            Policy.checkCanceled((IProgressMonitor)monitor);
        }
        monitor.worked(1);
    }

    protected String getName() {
        return this.getSubscriber().getName();
    }

    private class EventHandler
    extends BackgroundEventHandler {
        private List dispatchEvents;

        protected EventHandler(String jobName, String errorTitle) {
            super(jobName, errorTitle);
            this.dispatchEvents = new ArrayList();
        }

        protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            this.dispatchEvents.add(event);
        }

        protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
            if (this.dispatchEvents.isEmpty()) {
                return false;
            }
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            ResourceDiffTree[] locked = null;
            try {
                try {
                    locked = this.beginDispath();
                    for (BackgroundEventHandler.Event event : this.dispatchEvents) {
                        switch (event.getType()) {
                            case 1: {
                                this.handleRemove(event.getResource());
                                break;
                            }
                            case 2: {
                                this.handleChange(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                                break;
                            }
                        }
                        if (!this.isShutdown()) continue;
                        throw new OperationCanceledException();
                    }
                }
                catch (CoreException e) {
                    throw TeamException.asTeamException((CoreException)e);
                }
            }
            finally {
                try {
                    this.endDispatch(locked, monitor);
                }
                finally {
                    this.dispatchEvents.clear();
                }
            }
            return true;
        }

        private ResourceDiffTree[] beginDispath() {
            ChangeSet[] sets = SubclipseSubscriberChangeSetManager.this.getSets();
            ArrayList<ResourceDiffTree> lockedSets = new ArrayList<ResourceDiffTree>();
            try {
                int i = 0;
                while (i < sets.length) {
                    ActiveChangeSet set = (ActiveChangeSet)sets[i];
                    ResourceDiffTree tree = (ResourceDiffTree)set.getDiffTree();
                    lockedSets.add(tree);
                    tree.beginInput();
                    ++i;
                }
                return lockedSets.toArray(new ResourceDiffTree[lockedSets.size()]);
            }
            catch (RuntimeException e) {
                try {
                    for (ResourceDiffTree tree : lockedSets) {
                        try {
                            tree.endInput(null);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {}
            }
            throw e;
        }

        private void endDispatch(ResourceDiffTree[] locked, IProgressMonitor monitor) {
            if (locked == null) {
                return;
            }
            monitor.beginTask(null, 100 * locked.length);
            int i = 0;
            while (i < locked.length) {
                ResourceDiffTree tree = locked[i];
                try {
                    tree.endInput(Policy.subMonitorFor((IProgressMonitor)monitor, (int)100));
                }
                catch (RuntimeException e) {
                    TeamPlugin.log((int)4, (String)Messages.SubscriberChangeSetCollector_0, (Throwable)e);
                    throw e;
                }
                ++i;
            }
            monitor.done();
        }

        protected synchronized void queueEvent(BackgroundEventHandler.Event event, boolean front) {
            super.queueEvent(event, front);
        }

        private void handleRemove(IResource resource) {
            ChangeSet[] sets = SubclipseSubscriberChangeSetManager.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (!set.isEmpty()) {
                    set.rootRemoved(resource, 2);
                    if (set.isEmpty()) {
                        SubclipseSubscriberChangeSetManager.this.remove(set);
                    }
                }
                ++i;
            }
        }

        private void handleChange(IResource resource, int depth) throws CoreException {
            int i;
            IDiff diff = SubclipseSubscriberChangeSetManager.this.getDiff(resource);
            if (SubclipseSubscriberChangeSetManager.this.isModified(diff)) {
                ActiveChangeSet[] containingSets = this.getContainingSets(resource);
                if (containingSets.length == 0) {
                    if (SubclipseSubscriberChangeSetManager.this.getDefaultSet() != null) {
                        SubclipseSubscriberChangeSetManager.this.getDefaultSet().add(diff);
                    }
                } else {
                    i = 0;
                    while (i < containingSets.length) {
                        ActiveChangeSet set = containingSets[i];
                        set.add(diff);
                        ++i;
                    }
                }
            } else {
                this.removeFromAllSets(resource);
            }
            if (depth != 0) {
                IResource[] members = SubclipseSubscriberChangeSetManager.this.getSubscriber().members(resource);
                i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    this.handleChange(member, depth == 1 ? 0 : 2);
                    ++i;
                }
            }
        }

        private void removeFromAllSets(IResource resource) {
            ArrayList<ChangeSet> toRemove = new ArrayList<ChangeSet>();
            ChangeSet[] sets = SubclipseSubscriberChangeSetManager.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (set.contains(resource)) {
                    set.remove(resource);
                    if (set.isEmpty()) {
                        toRemove.add(set);
                    }
                }
                ++i;
            }
            for (ChangeSet set : toRemove) {
                SubclipseSubscriberChangeSetManager.this.remove(set);
            }
        }

        private ActiveChangeSet[] getContainingSets(IResource resource) {
            HashSet<ChangeSet> result = new HashSet<ChangeSet>();
            ChangeSet[] sets = SubclipseSubscriberChangeSetManager.this.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet set = sets[i];
                if (set.contains(resource)) {
                    result.add(set);
                }
                ++i;
            }
            return result.toArray(new ActiveChangeSet[result.size()]);
        }
    }

    private class ResourceCollector
    extends SubclipseSubscriberResourceCollector {
        public ResourceCollector(Subscriber subscriber) {
            super(subscriber);
        }

        @Override
        protected void remove(IResource resource) {
            if (SubclipseSubscriberChangeSetManager.this.handler != null) {
                SubclipseSubscriberChangeSetManager.this.handler.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(resource, 1, 2), false);
            }
        }

        @Override
        protected void change(IResource resource, int depth) {
            if (SubclipseSubscriberChangeSetManager.this.handler != null) {
                SubclipseSubscriberChangeSetManager.this.handler.queueEvent((BackgroundEventHandler.Event)new BackgroundEventHandler.ResourceEvent(resource, 2, depth), false);
            }
        }

        @Override
        protected boolean hasMembers(IResource resource) {
            return SubclipseSubscriberChangeSetManager.this.hasMembers(resource);
        }
    }
}

