/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.tigris.subversion.subclipse.core.properties.SVNPropertyDefinition;

public class SVNPropertyManager {
    private static SVNPropertyManager instance;
    private SVNPropertyDefinition[] definitions;
    private SVNPropertyDefinition[] fileDefinitions;
    private SVNPropertyDefinition[] folderDefinitions;

    public static SVNPropertyManager getInstance() {
        if (instance == null) {
            instance = new SVNPropertyManager();
        }
        return instance;
    }

    private SVNPropertyManager() {
        this.loadPropertiesFromExtensions();
    }

    private void loadPropertiesFromExtensions() {
        IExtension[] extensions;
        ArrayList<SVNPropertyDefinition> propertyTypes = new ArrayList<SVNPropertyDefinition>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.tigris.subversion.subclipse.core", "svnPropertyTypes");
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray[n4];
                String name = configElement.getAttribute("name");
                String type = configElement.getAttribute("type");
                String fileOrFolder = configElement.getAttribute("fileOrFolder");
                String allowRecurse = configElement.getAttribute("allowRecurse");
                String description = "";
                IConfigurationElement[] descriptionElements = configElement.getChildren("description");
                if (descriptionElements.length == 1) {
                    description = descriptionElements[0].getValue();
                }
                int showFor = fileOrFolder.equals("file") ? 2 : (fileOrFolder.equals("folder") ? 1 : 0);
                boolean recurse = true;
                if (allowRecurse != null && allowRecurse.equalsIgnoreCase("false")) {
                    recurse = false;
                }
                SVNPropertyDefinition property = new SVNPropertyDefinition(name, description, showFor, recurse, type);
                propertyTypes.add(property);
                ++n4;
            }
            ++n2;
        }
        this.definitions = new SVNPropertyDefinition[propertyTypes.size()];
        propertyTypes.toArray(this.definitions);
        Arrays.sort(this.definitions);
        ArrayList<SVNPropertyDefinition> fileProperties = new ArrayList<SVNPropertyDefinition>();
        ArrayList<SVNPropertyDefinition> folderProperties = new ArrayList<SVNPropertyDefinition>();
        SVNPropertyDefinition[] sVNPropertyDefinitionArray = this.definitions;
        int n5 = this.definitions.length;
        int n6 = 0;
        while (n6 < n5) {
            SVNPropertyDefinition definition = sVNPropertyDefinitionArray[n6];
            if (definition.showForFile()) {
                fileProperties.add(definition);
            }
            if (definition.showForFolder()) {
                folderProperties.add(definition);
            }
            ++n6;
        }
        this.fileDefinitions = new SVNPropertyDefinition[fileProperties.size()];
        fileProperties.toArray(this.fileDefinitions);
        this.folderDefinitions = new SVNPropertyDefinition[folderProperties.size()];
        folderProperties.toArray(this.folderDefinitions);
    }

    public SVNPropertyDefinition[] getPropertyTypes() {
        return this.definitions;
    }

    public SVNPropertyDefinition[] getFilePropertyTypes() {
        return this.fileDefinitions;
    }

    public SVNPropertyDefinition[] getFolderPropertyTypes() {
        return this.folderDefinitions;
    }
}

