/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNLock;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RemoteFolder
extends RemoteResource
implements ISVNRemoteFolder,
ISVNFolder {
    protected ISVNRemoteResource[] children;

    public RemoteFolder(RemoteFolder parent, ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision, SVNRevision.Number lastChangedRevision, Date date, String author) {
        super(parent, repository, url, revision, lastChangedRevision, date, author);
    }

    public RemoteFolder(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        super(repository, url, revision);
    }

    public RemoteFolder(IResource resource, byte[] bytes) {
        super(resource, bytes);
    }

    public RemoteFolder(RemoteResourceStatus remoteStatusInfo) {
        this(null, remoteStatusInfo.getRepository(), remoteStatusInfo.getUrl(), (SVNRevision)remoteStatusInfo.getRepositoryRevision(), remoteStatusInfo.getLastChangedRevision(), remoteStatusInfo.getLastChangedDate(), remoteStatusInfo.getLastCommitAuthor());
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws TeamException {
        try {
            this.getMembers(monitor);
            return true;
        }
        catch (SVNException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
    }

    protected boolean exists(ISVNRemoteResource child, IProgressMonitor monitor) throws SVNException {
        ISVNRemoteResource[] members;
        try {
            members = this.getMembers(monitor);
        }
        catch (SVNException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
        int i = 0;
        while (i < members.length) {
            if (members[i].equals(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void refresh() {
        this.children = null;
    }

    protected ISVNRemoteResource[] getMembers(IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.getMembers"), 100);
        if (this.children != null) {
            progress.done();
            return this.children;
        }
        ISVNClientAdapter client = null;
        try {
            ISVNDirEntry entry;
            ISVNDirEntryWithLock entryWithLock;
            client = this.getRepository().getSVNClient();
            ISVNDirEntryWithLock[] list = client.getListWithLocks(this.url, this.getRevision(), SVNRevision.HEAD, false);
            ArrayList<RemoteResource> result = new ArrayList<RemoteResource>(list.length);
            ISVNDirEntryWithLock[] iSVNDirEntryWithLockArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                entryWithLock = iSVNDirEntryWithLockArray[n2];
                entry = entryWithLock.getDirEntry();
                if (entry.getNodeKind() == SVNNodeKind.DIR) {
                    result.add(new RemoteFolder(this, this.getRepository(), this.url.appendPath(entry.getPath()), this.getRevision(), entry.getLastChangedRevision(), entry.getLastChangedDate(), entry.getLastCommitAuthor()));
                }
                ++n2;
            }
            iSVNDirEntryWithLockArray = list;
            n = list.length;
            n2 = 0;
            while (n2 < n) {
                entryWithLock = iSVNDirEntryWithLockArray[n2];
                entry = entryWithLock.getDirEntry();
                ISVNLock lock = entryWithLock.getLock();
                if (entry.getNodeKind() == SVNNodeKind.FILE) {
                    RemoteFile remoteFile = new RemoteFile(this, this.getRepository(), this.url.appendPath(entry.getPath()), this.getRevision(), entry.getLastChangedRevision(), entry.getLastChangedDate(), entry.getLastCommitAuthor());
                    remoteFile.setPegRevision(this.getRevision());
                    remoteFile.setLock(lock);
                    result.add(remoteFile);
                }
                ++n2;
            }
            this.children = result.toArray(new ISVNRemoteResource[result.size()]);
            ISVNRemoteResource[] iSVNRemoteResourceArray = this.children;
            return iSVNRemoteResourceArray;
        }
        catch (SVNClientException sVNClientException) {
            throw new SVNException((IStatus)new SVNStatus(4, -17, Policy.bind("RemoteFolder.doesNotExist", this.getRepositoryRelativePath())));
        }
        finally {
            this.getRepository().returnSVNClient(client);
            progress.done();
        }
    }

    @Override
    public ISVNResource[] members(IProgressMonitor monitor, int flags) throws SVNException {
        ArrayList<ISVNRemoteResource> result = new ArrayList<ISVNRemoteResource>();
        ISVNRemoteResource[] resources = this.getMembers(monitor);
        if ((flags & 0x20) == 0 && (flags & 0x40) == 1) {
            return new ISVNResource[0];
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        ISVNRemoteResource[] iSVNRemoteResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNRemoteResource svnResource = iSVNRemoteResourceArray[n2];
            if ((includeFiles && !svnResource.isFolder() || includeFolders && svnResource.isFolder()) && includeManaged) {
                result.add(svnResource);
            }
            ++n2;
        }
        return result.toArray(new ISVNResource[result.size()]);
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public ISVNRemoteResource[] members(IProgressMonitor progress) throws TeamException {
        return this.getMembers(progress);
    }

    @Override
    public void createRemoteFolder(String folderName, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.createRemoteFolder"), 100);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = this.getRepository().getSVNClient();
                svnClient.mkdir(this.getUrl().appendPath(folderName), message);
                this.refresh();
                SVNProviderPlugin.getPlugin().getRepositoryResourcesManager().remoteResourceCreated(this, folderName);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            this.getRepository().returnSVNClient(svnClient);
            progress.done();
        }
    }

    protected void fetchContents(IProgressMonitor monitor) {
    }
}

