/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.RepositoryProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.LockResourcesCommand;
import org.tigris.subversion.subclipse.core.resources.ISVNFileModificationValidatorPrompt;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class SVNFileModificationValidator
implements IFileModificationValidator {
    private IFileModificationValidator uiValidator;
    private static final String ID = "org.eclipse.team.core";
    private static final String DEFAULT_FILE_MODIFICATION_VALIDATOR_EXTENSION = "defaultFileModificationValidator";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validateEdit(IFile[] files, Object context) {
        IFile[] unManagedFiles;
        String comment = "";
        boolean stealLock = false;
        ReadOnlyFiles readOnlyFiles = this.processFileArray(files);
        if (readOnlyFiles.size() == 0) {
            return Status.OK_STATUS;
        }
        IFile[] managedFiles = readOnlyFiles.getManaged();
        if (managedFiles.length > 0) {
            RepositoryProvider provider;
            ISVNFileModificationValidatorPrompt svnFileModificationValidatorPrompt;
            if (context != null && (svnFileModificationValidatorPrompt = SVNProviderPlugin.getPlugin().getSvnFileModificationValidatorPrompt()) != null) {
                if (!svnFileModificationValidatorPrompt.prompt(managedFiles, context)) {
                    return Status.CANCEL_STATUS;
                }
                comment = svnFileModificationValidatorPrompt.getComment();
                stealLock = svnFileModificationValidatorPrompt.isStealLock();
            }
            if ((provider = RepositoryProvider.getProvider((IProject)managedFiles[0].getProject())) != null && provider instanceof SVNTeamProvider) {
                SVNTeamProvider svnTeamProvider = (SVNTeamProvider)provider;
                LockResourcesCommand command = new LockResourcesCommand(svnTeamProvider.getSVNWorkspaceRoot(), (IResource[])managedFiles, stealLock, comment, false);
                try {
                    command.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (SVNException e) {
                    SVNProviderPlugin.log(4, e.getMessage(), (Throwable)((Object)e));
                    return Status.CANCEL_STATUS;
                }
            }
        }
        if ((unManagedFiles = readOnlyFiles.getUnManaged()).length > 0) {
            SVNFileModificationValidator sVNFileModificationValidator = this;
            synchronized (sVNFileModificationValidator) {
                if (this.uiValidator == null) {
                    this.uiValidator = this.loadUIValidator();
                }
            }
            if (this.uiValidator != null) {
                return this.uiValidator.validateEdit(unManagedFiles, context);
            }
            return this.getStatus(unManagedFiles);
        }
        return Status.OK_STATUS;
    }

    public IStatus validateSave(IFile file) {
        return Status.OK_STATUS;
    }

    private ReadOnlyFiles processFileArray(IFile[] files) {
        ReadOnlyFiles result = new ReadOnlyFiles();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (this.isReadOnly(file)) {
                try {
                    ISVNLocalResource resource = SVNWorkspaceRoot.getSVNResourceFor((IResource)file);
                    if (resource.isManaged()) {
                        if (this.hasNeedsLockProperty(resource)) {
                            result.addManaged(file);
                        } else {
                            result.addUnManaged(file);
                        }
                    } else {
                        result.addUnManaged(file);
                    }
                }
                catch (SVNException sVNException) {
                    result.addUnManaged(file);
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean hasNeedsLockProperty(ISVNLocalResource resource) {
        try {
            ISVNProperty needsLock = resource.getSvnProperty("svn:needs-lock");
            return needsLock != null && needsLock.getValue().length() > 0;
        }
        catch (SVNException sVNException) {
            return false;
        }
    }

    private boolean isReadOnly(IFile file) {
        if (file == null) {
            return false;
        }
        File fsFile = file.getLocation().toFile();
        return fsFile != null && !fsFile.canWrite();
    }

    private IStatus getDefaultStatus(IFile file) {
        return this.isReadOnly(file) ? new Status(4, "org.tigris.subversion.subclipse.core", 279, Policy.bind("FileModificationValidator.fileIsReadOnly", new String[]{file.getFullPath().toString()}), null) : Status.OK_STATUS;
    }

    protected IStatus getStatus(IFile[] files) {
        if (files.length == 1) {
            return this.getDefaultStatus(files[0]);
        }
        Status[] stati = new Status[files.length];
        boolean allOK = true;
        int i = 0;
        while (i < files.length) {
            stati[i] = this.getDefaultStatus(files[i]);
            if (!stati[i].isOK()) {
                allOK = false;
            }
            ++i;
        }
        return new MultiStatus("org.tigris.subversion.subclipse.core", 0, (IStatus[])stati, allOK ? Policy.bind("ok") : Policy.bind("FileModificationValidator.someReadOnly"), null);
    }

    private IFileModificationValidator loadUIValidator() {
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(ID, DEFAULT_FILE_MODIFICATION_VALIDATOR_EXTENSION);
        if (extension != null && (extensions = extension.getExtensions()).length > 0 && (configElements = extensions[0].getConfigurationElements()).length > 0) {
            try {
                Object o = configElements[0].createExecutableExtension("class");
                if (o instanceof IFileModificationValidator) {
                    return (IFileModificationValidator)o;
                }
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
            }
        }
        return null;
    }

    private class ReadOnlyFiles {
        private List<IFile> managed = new ArrayList<IFile>();
        private List<IFile> unManaged = new ArrayList<IFile>();

        public void addManaged(IFile file) {
            this.managed.add(file);
        }

        public void addUnManaged(IFile file) {
            this.unManaged.add(file);
        }

        public IFile[] getManaged() {
            return this.managed.toArray(new IFile[this.managed.size()]);
        }

        public IFile[] getUnManaged() {
            return this.unManaged.toArray(new IFile[this.unManaged.size()]);
        }

        public int size() {
            return this.managed.size() + this.unManaged.size();
        }
    }
}

