/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.svgimporter.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.layout.ChangeLayoutCommand;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.svgimporter.ConsolePdfConverter;
import com.jaspersoft.studio.svgimporter.SVGDocumentLoader;
import com.jaspersoft.studio.svgimporter.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;

public class ImportContentAction
extends ACachedSelectionAction {
    public static final String ID = "importcontent";

    public ImportContentAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.ImportContentAction_actionName);
        this.setToolTipText(Messages.ImportContentAction_actionTooltip);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        List bands = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        return bands.size() == 1;
    }

    protected Command createCommand() {
        List bands = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        if (bands.size() == 1) {
            MBand bandNode = (MBand)bands.get(0);
            JSSCompoundCommand command = new JSSCompoundCommand((ANode)bandNode);
            command.add((Command)new ImportElementsCommand(bandNode));
            return command;
        }
        return null;
    }

    private class ImportElementsCommand
    extends Command {
        private List<JRDesignElement> elementsToCreate = new ArrayList<JRDesignElement>();
        private JRDesignBand targetBand;
        private MBand band;
        private Command createResourceCommand;
        private ChangeLayoutCommand changeLayoutCommand;

        public ImportElementsCommand(MBand band) {
            this.band = band;
            this.targetBand = band.getValue();
            this.changeLayoutCommand = new ChangeLayoutCommand((APropertyNode)band, (ILayout)new FreeLayout());
        }

        public void execute() {
            this.elementsToCreate.clear();
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
            dialog.setFilterExtensions(new String[]{"*.svg", "*.pdf"});
            String result = dialog.open();
            if (result != null) {
                JasperReportsConfiguration jConfig = this.band.getJasperConfiguration();
                try {
                    File resultFile = new File(result);
                    String ext = FilenameUtils.getExtension((String)resultFile.getName());
                    File fileToConvert = null;
                    if (ext.equalsIgnoreCase("pdf")) {
                        ConsolePdfConverter converter = new ConsolePdfConverter(Arrays.asList(resultFile));
                        List<File> convertedFiles = converter.getConvertedFiles();
                        if (!convertedFiles.isEmpty()) {
                            fileToConvert = convertedFiles.get(0);
                        }
                    } else {
                        fileToConvert = resultFile;
                    }
                    if (fileToConvert != null) {
                        SVGDocumentLoader loader = new SVGDocumentLoader(fileToConvert.toURI().toString(), jConfig);
                        this.elementsToCreate.addAll(loader.getJRElements());
                        this.changeLayoutCommand.execute();
                        this.createResourceCommand = loader.getResourceCreationCommands();
                        if (this.createResourceCommand != null) {
                            this.createResourceCommand.execute();
                        }
                        for (JRDesignElement element : this.elementsToCreate) {
                            this.targetBand.addElement(element);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void undo() {
            if (this.createResourceCommand != null) {
                this.createResourceCommand.undo();
            }
            for (JRDesignElement element : this.elementsToCreate) {
                this.targetBand.removeElement(element);
            }
            this.changeLayoutCommand.undo();
        }

        public void redo() {
            this.changeLayoutCommand.execute();
            if (this.createResourceCommand != null) {
                this.createResourceCommand.redo();
            }
            for (JRDesignElement element : this.elementsToCreate) {
                this.targetBand.addElement(element);
            }
        }
    }
}

